/* $Id: er_plugin.h,v 1.14 2009/12/11 16:35:22 cgarcia Exp $
 *
 *   This file is part of the ESO Common Pipeline Library
 *   Copyright (C) 2001-2008 European Southern Observatory
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2009/12/11 16:35:22 $
 * $Revision: 1.14 $
 * $Name: esorex-3_9_0 $
 */


#ifndef ER_PLUGIN_H
#define ER_PLUGIN_H

# include <cxstrutils.h>

#include <cpl.h>

#include <er_stringarray.h>

#endif	/* ER_PLUGIN_H */


CPL_BEGIN_DECLS

extern int plugin_process_plugin
(
  cpl_parameterlist *,
  char *,
  er_stringarray_t *,
  int, 
  char **
);

extern cpl_msg_severity message_severity
(
  cpl_parameterlist *param_list,
  int  flag
);

extern void er_enlarge
(
  const char *fn, 
  char **pptr, 
  int msize
)
;

extern int  mysscanf 
(
  char *myline,
  char *path,
  char * tag,
  char * group
)
;

extern cpl_frameset *er_frameset_load 
(
  const char *name,
  cpl_frameset * set,
  int check_input_files_flag
)
;

extern int upda_products 
(
  cpl_frameset * frameset
)
;

extern int move_products 
(
  cpl_frameset * frameset,
  char * output_directory,
  char * output_prefix,
  char * link_directory,
  int flag_noprefix, 
  int flag_nolink, 
  int flag_readonly
)
;


CPL_END_DECLS



/* End of file */

