#ifndef __CSINKSSL_H__
#define __CSINKSSL_H__

/* csinkssl.h
 * This module depends on: 
 * Author(s): Jim Meier
 *
 * This file and csinkssl.c are covered under the license as specified in
 * the top level LICENSE file.
 */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/poll.h>
#include <sys/time.h>

/* SSL headers. */
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/rand.h>
#include <openssl/err.h>

/* CSink headers. */
#include "csinkinet.h"

/* Casting macro. */
#define CSINK_SSL(sink) ((CSinkSSL*)sink)
#define CSINK_SSL_TYPE	0xaefdc

typedef struct _CSinkSSL CSinkSSL;
typedef gint (*CSinkSSLOnCertCheckFunc) (CSinkSSL * sink, X509 * server_cert);

typedef enum {
    SSS_CONNECTED, 	/* Inet socket connected.       */
    SSS_NOTCONNECTED,	/* Disconnected from server.    */
    SSS_WAITING,	/* Asked for a connection.      */
    SSS_SSL_WAITING,	/* Asked for SSL connection.    */
    SSS_SSL_CONNECTED,	/* SSL connection complete.	*/
    SSS_SSL_CONNECTING,	/* SSL connection in progrss.	*/
    SSS_SSL_ACCEPTING	/* The sink is accepting.	*/
} CSinkSSLStatus;

struct _CSinkSSL {
    CSinkInet inet;		/* The sink, must be first. */

    /* SSL information. */
    SSL_CTX *ctx;
    SSL *ssl;
    X509 *cert;			/* Used for verifying the peer, which I don't 
				 * do yet. */
    char *certf;
    char *keyf;
    SSL_METHOD *meth;		/* Crypt method to use. Kinda fuzzy on this. */
    /* Example: SSLv3_client_method.  I think that we really don't
     * need the meth because it looks like the methos is global. */

    CSinkSSLOnCertCheckFunc on_cert_check;
    CSinkSSLStatus status;
    int must_write;
    int must_read;

    /* Something that ssl needs to send into SSL_CTX_set_session_id_context() */
    int session_id_context;

    int verify_depth;

    /* The locations of the certs and keys. */
    char * cert_file;
    char * cert_dir;
};

CSinkSSL * csink_ssl_create (CSinkSSL * old_sink);
void csink_ssl_init (CSinkSSL * sink);

/* Constructor. */
/* CSinkSSL *  */
/* csink_ssl_new (); */

void csink_ssl_set_certcheck_func (CSinkSSL *sink, 
				   CSinkSSLOnCertCheckFunc func);

/* Set the file containing the SSL key. */
void csink_ssl_set_certfile (CSinkSSL *sink, char * cert_file);
void csink_ssl_set_certdir (CSinkSSL * sink, char * cert_dir);

/* Verify that SSL is setup for the sink. */
int csink_ssl_cert_info (CSinkSSL * sink);

/* Set file containing cert. */
void csink_ssl_set_certfile (CSinkSSL * sink, gchar * filename);

/* Set the SSL method.  Again, I don't know the differences. FIXME */
void csink_ssl_set_meth (CSinkSSL * sink, SSL_METHOD * meth);

#endif /* __CSINKSSL_H__ */

