#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
# 
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
# 
# Author: Enthought, Inc.
# Description: <Enthought pyface package component>
#------------------------------------------------------------------------------
""" System metrics (screen width and height etc). """


# Major package imports.
import wx

# Enthought library imports.
from enthought.traits.api import HasPrivateTraits, Int, Property


class SystemMetrics(HasPrivateTraits):
    """ System metrics (screen width and height etc). """
    
    # fixme: add in all the other metrics as we find the need for them.

    #### 'SystemMetrics' interface ############################################
    
    # The width of the screen in pixels.    
    screen_width = Property(Int)

    # The height of the screen in pixels.
    screen_height = Property(Int)
    
    # Background color of a standard dialog window as a tuple of RGB values 
    # between 0.0 and 1.0.
    dialog_background_color = Property
    
    ###########################################################################
    # 'SystemMetrics' interface.
    ###########################################################################

    #### Properties ###########################################################
    
    def _get_screen_width(self):
        """ Returns the width of the scene in pixels. """
        
        return wx.SystemSettings.GetMetric( wx.SYS_SCREEN_X )
    
    def _get_screen_height(self):
        """ Returns the height of the scene in pixels. """
        
        return wx.SystemSettings.GetMetric( wx.SYS_SCREEN_Y )

    def _get_dialog_background_color(self):
        """ Returns background color of a standard dialog window as an
            RGB tuple.  RGB values range between 0.0-1.0 
        """

        wx_color = wx.SystemSettings_GetColour(wx.SYS_COLOUR_BTNFACE)    
        color = wx_color.Get()
        
        return (color[0]/255., color[1]/255., color[2]/255.)
        
        
#### EOF ######################################################################
