"""
This file pulls in the Kiva constants and does the detection of what backend
to use via the KIVA_WISHLIST environment variable.
"""

#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# some parts copyright 2002 by Space Telescope Science Institute
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#------------------------------------------------------------------------------

import os
import sys
from constants import *
from fonttools import Font   # relative import; not the fonttools project!

from enthought.kiva.version import version, version as __version__


# The code is borrowed almost exactly from the AnyGui __init__.py
# code.  Nice code.

# This module is really just a shell around the various core2d backends.  It
# loops through a list of possible backends until it finds on that is
# available.  You can override the standard list of backends by setting the
# environment variable KIVA_WISHLIST before importing.  The environment
# variable is a space separated list of backends.  The first available
# one in the list is chosen.


_backends = 'wx qt gl image pdf svg ps'

_backend = None
DEBUG = 1
wishlist = os.environ.get('KIVA_WISHLIST', _backends).split()

# Symbols we import from the selected backend
backend_symbols = ('GraphicsContext', 'Canvas', 'CompiledPath',
    'font_metrics_provider')

def _dotted_import(name):
    # version of __import__ which handles dotted names
    # copied from python docs for __import__
    import string
    mod = __import__(name, globals(), locals(), [])
    components = string.split(name, '.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod

def _backend_passthrough():
    global _backends, _backend
    _backends = _backends.split()
    _backends = [b for b in _backends if not b in wishlist]
    if wishlist:
        try:
            idx = wishlist.index('*')
            wishlist[idx:idx+1] = _backends
        except ValueError: pass
        _backends = wishlist
    for name in _backends:
        try:
            mod = _dotted_import('backend_%s' % name,)
            for key in backend_symbols:
                globals()[key] = mod.__dict__[key]
            return
        except (ImportError, AttributeError, KeyError):
            if DEBUG and not (str(DEBUG) in _backends and not DEBUG==name):
                import traceback
                traceback.print_exc()
            continue
        else:
            _backend = name
            return
    raise RuntimeError("no usable backend found")

def backend():
    'Return the name of the current backend'
    if not _backend:
        raise RuntimeError('no backend exists')
    return _backend

# Pass the backend namespace through:
_backend_passthrough()


