"""
This builds on the simple_wx_demo and allows a simple component to be moved
around the screen.
"""

from enthought.traits.api import Float, Tuple

from enthought.enable import Component, Container, Pointer
from enthought.enable.wx import Window

# Relative imports
from demo_base import DemoFrame, demo_main

class Box(Component):
    """
    The box moves wherever the user clicks and drags.
    """
    normal_pointer = Pointer("arrow")
    moving_pointer = Pointer("hand")
    
    offset_x = Float
    offset_y = Float
    
    def _draw(self, gc):
        gc.save_state()
        gc.set_fill_color((1.0, 0.0, 0.0, 1.0))
        x, y, dx, dy = self.bounds
        gc.rect(x, y, dx, dy)
        gc.fill_path()
        gc.restore_state()
        return

    def normal_left_down(self, event):
        self.event_state = "moving"
        self.pointer = self.moving_pointer
        self.offset_x = event.x - self.bounds[0]
        self.offset_y = event.y - self.bounds[1]
        return

    def moving_mouse_move(self, event):
        self.bounds = (event.x-self.offset_x, event.y-self.offset_y, self.bounds[2], self.bounds[3])
        self.redraw()
        return

    def moving_left_up(self, event):
        self.event_state = "normal"
        self.pointer = self.normal_pointer
        return

class MyFrame(DemoFrame):
    def _create_window(self):
        box = Box(bounds=(50,50,100,100))
        container = Container(bounds=(0,0,500,500))
        container.add(box)
        return Window(self, -1, component=container)

if __name__ == "__main__":
    demo_main(MyFrame, title="Click and drag to move the box")

# EOF
