#-------------------------------------------------------------------------------
#
#  Defines traits used by the 'om' (Object Model) package.
#
#  Written by: David C. Morrill
#
#  Date: 01/28/2005
#
#  (c) Copyright 2005 by Enthought, Inc.
#
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from enthought.enable    import TOP, BOTTOM, LEFT, RIGHT
from enthought.enable.traits.rgba_color_trait import RGBAColor
from enthought.enable.traits.ui.wx.enable_rgba_color_editor import \
    EnableRGBAColorEditor
from enthought.traits.api    import Trait, Tuple, Int, Str, Enum, Delegate

#-------------------------------------------------------------------------------
#  Constants:
#-------------------------------------------------------------------------------

# Alignment values:
CENTER       = 0
INSIDE       = 64
OUTSIDE      = 128

TOP_LEFT     = TOP    | LEFT
TOP_RIGHT    = TOP    | RIGHT
BOTTOM_LEFT  = BOTTOM | LEFT
BOTTOM_RIGHT = BOTTOM | RIGHT

#-------------------------------------------------------------------------------
#  Trait definitions:
#-------------------------------------------------------------------------------

# Position of a contact relative to its containing component:
ContactPosition = Trait( 'left', {
    'top left':     TOP_LEFT,
    'top':          TOP,
    'top right':    TOP_RIGHT,
    'left':         LEFT,
    'center':       CENTER,
    'right':        RIGHT,
    'bottom left':  BOTTOM_LEFT,
    'bottom':       BOTTOM,
    'bottom right': BOTTOM_RIGHT
} )

# Position of a label relative to its associated contact and containing
# component:
ContactLabelPosition = Trait( 'outside top left', {
    'top left':             TOP_LEFT,
    'top':                  TOP,
    'top right':            TOP_RIGHT,
    'left':                 LEFT,
    'center':               CENTER,
    'right':                RIGHT,
    'bottom left':          BOTTOM_LEFT,
    'bottom':               BOTTOM,
    'bottom right':         BOTTOM_RIGHT,
    'inside top left':      INSIDE  | TOP_LEFT,
    'inside top':           INSIDE  | TOP,
    'inside top right':     INSIDE  | TOP_RIGHT,
    'inside left':          INSIDE  | LEFT,
    'inside center':        INSIDE  | CENTER,
    'inside right':         INSIDE  | RIGHT,
    'inside bottom left':   INSIDE  | BOTTOM_LEFT,
    'inside bottom':        INSIDE  | BOTTOM,
    'inside bottom right':  INSIDE  | BOTTOM_RIGHT,
    'outside top left':     OUTSIDE | TOP_LEFT,
    'outside top':          OUTSIDE | TOP,
    'outside top right':    OUTSIDE | TOP_RIGHT,
    'outside left':         OUTSIDE | LEFT,
    'outside center':       OUTSIDE | CENTER,
    'outside right':        OUTSIDE | RIGHT,
    'outside bottom left':  OUTSIDE | BOTTOM_LEFT,
    'outside bottom':       OUTSIDE | BOTTOM,
    'outside bottom right': OUTSIDE | BOTTOM_RIGHT
} )

# Position of an inner component relative to the outer component:
InnerComponentPosition = Trait( 'center', {
    'top':    TOP,
    'center': CENTER,
    'bottom': BOTTOM
} )

# A Contact/ContactManager/Track category:
ContactCategory = Str( 'default' )

# A Contact/ContactManager/Track group:
ContactGroup = Str( 'default' )

# An (x,y) offset:
OffsetXY = Tuple( Int, Int,
                  cols = 2, labels = [ 'X', 'Y' ] )

# A (dx,dy) size:
SizeXY = Tuple( Int, Int,
                cols = 2, labels = [ 'Width', 'Height' ] )

# Delegate a trait to the object's 'style' attribute:
StyleDelegate = Delegate( 'style' )

# The current state of a Contact:
ContactState = Enum( 'unconnected', 'connected', 'fully_connected',
                     'drag_pending', 'drop_pending' )

# RGBA Color using the Enable RGBA color editor:
ergba_color_editor = EnableRGBAColorEditor( mode = 'hsv' )
ERGBAColor         = RGBAColor( editor = ergba_color_editor )

# Selection bacground and border colors:
SelectionBackgroundColor = ERGBAColor( ( 0.0, 0.7, 0.2, 0.2 ) )
SelectionBorderColor     = ERGBAColor( ( 0.0, 0.0, 0.0, 0.4 ) )

