/*
		       Endeavour Recycle Bin
 */

#ifndef RECBIN_H
#define RECBIN_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edv_types.h"
#include "toolbar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"


typedef struct _edv_recbin_struct	edv_recbin_struct;
#define EDV_RECBIN(p)			((edv_recbin_struct *)(p))

typedef struct _edv_recbin_opid_struct	edv_recbin_opid_struct;
#define EDV_RECBIN_OPID(p)		((edv_recbin_opid_struct *)(p))


/*
 *	Recycle Bin Contents List Column Types:
 */
typedef enum {
	EDV_RECBIN_COLUMN_TYPE_INDEX			= 0,
	EDV_RECBIN_COLUMN_TYPE_NAME			= 1,
	EDV_RECBIN_COLUMN_TYPE_SIZE			= 2,
	EDV_RECBIN_COLUMN_TYPE_TYPE			= 3,
	EDV_RECBIN_COLUMN_TYPE_PERMISSIONS		= 4,
	EDV_RECBIN_COLUMN_TYPE_OWNER			= 5,
	EDV_RECBIN_COLUMN_TYPE_GROUP			= 6,
	EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS		= 7,
	EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED		= 8,
	EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED		= 9,
	EDV_RECBIN_COLUMN_TYPE_DATE_DELETED		= 10,
	EDV_RECBIN_COLUMN_TYPE_LINKED_TO		= 11,
	EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION	= 12,
	EDV_RECBIN_COLUMN_TYPE_CAPACITY_USED		= 13
} edv_recbin_column_type;
/* Total number of column types */
#define EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX		14


/*
 *	Recycle Bin Operations:
 */
typedef enum {

	EDV_RECBIN_OP_NONE			= 0,
	EDV_RECBIN_OP_SEPARATOR			= 100,

	EDV_RECBIN_OP_CLOSE			= 200,
	EDV_RECBIN_OP_EXIT			= 201,

	EDV_RECBIN_OP_SYNC_DISKS		= 301,
	EDV_RECBIN_OP_HISTORY			= 302,
	EDV_RECBIN_OP_RUN			= 303,
	EDV_RECBIN_OP_RUN_TERMINAL		= 304,
	EDV_RECBIN_OP_WRITE_PROTECT		= 305,
	EDV_RECBIN_OP_DELETE_METHOD_RECYCLE	= 308,
	EDV_RECBIN_OP_DELETE_METHOD_PURGE	= 309,

	EDV_RECBIN_OP_SYNC_RECYCLE_BIN		= 350,

	EDV_RECBIN_OP_RECOVER			= 700,
	EDV_RECBIN_OP_PURGE			= 701,
	EDV_RECBIN_OP_PURGE_ALL			= 702,
	EDV_RECBIN_OP_RENAME			= 703,
	EDV_RECBIN_OP_CHMOD			= 704,
	EDV_RECBIN_OP_CHOWN			= 705,
	EDV_RECBIN_OP_CHTIME			= 706,
	EDV_RECBIN_OP_PROPERTIES		= 707,

	EDV_RECBIN_OP_SELECT_ALL		= 800,
	EDV_RECBIN_OP_UNSELECT_ALL		= 801,
	EDV_RECBIN_OP_INVERT_SELECTION		= 802,
	EDV_RECBIN_OP_FIND			= 850,

	EDV_RECBIN_OP_REFRESH			= 1000,
	EDV_RECBIN_OP_REFRESH_ALL		= 1001,

	EDV_RECBIN_OP_SHOW_TOOL_BAR		= 1300,
	EDV_RECBIN_OP_SHOW_FIND_BAR		= 1303,
	EDV_RECBIN_OP_SHOW_STATUS_BAR		= 1304,

	EDV_RECBIN_OP_CONTENTS_LIST_FILTER	= 1400,
	EDV_RECBIN_OP_CONTENTS_LIST_AUTO_RESIZE_COLUMNS = 1410,

	EDV_RECBIN_OP_MIME_TYPES		= 1700,

	EDV_RECBIN_OP_NEW_BROWSER		= 1800,
	EDV_RECBIN_OP_NEW_IMBR			= 1801,
	EDV_RECBIN_OP_NEW_ARCHIVER		= 1802,

	EDV_RECBIN_OP_OPTIONS			= 2000,
	EDV_RECBIN_OP_CUSTOMIZE			= 2001,

	EDV_RECBIN_OP_HELP_CONTENTS		= 3000,
	EDV_RECBIN_OP_HELP_FILE_BROWSER		= 3010,
	EDV_RECBIN_OP_HELP_IMAGE_BROWSER	= 3011,
	EDV_RECBIN_OP_HELP_ARCHIVER		= 3012,
	EDV_RECBIN_OP_HELP_RECYCLE_BIN		= 3030,
	EDV_RECBIN_OP_HELP_KEYS_LIST		= 3050,
	EDV_RECBIN_OP_HELP_COMMON_OPERATIONS	= 3053,
	EDV_RECBIN_OP_HELP_ABOUT		= 3100

} edv_recbin_op;


/*
 *	Recycle Bin Operation ID:
 */
struct _edv_recbin_opid_struct {

	edv_recbin_op	op;
	edv_opid_flags	flags;
	toolbar_item_type	tb_item_type;
	edv_recbin_struct	*recbin;

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar		*button_name;	/* Name as it would appear on a button */
	gchar		*menu_name;	/* Name as it would appear on a menu item */
	gchar		*tooltip;	/* Tool tip or description (one line) */

	guint		accel_key,	/* Accelerator key */
			accel_mods;	/* Accelerator key modifiers */

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};

/*
 *	Recycle Bin:
 */
struct _edv_recbin_struct {

	GtkWidget	*toplevel;
	gboolean	processing;
	gint		freeze_count,
			busy_count;
	edv_core_struct *core;

	GList		*opid_list;

	gboolean	tool_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*find_bar_handle,

			*contents_clist;	/* Contents GtkCList */

	/* Tool Bar */
	toolbar_struct		*tool_bar;

	/* Find Bar */
	edv_find_bar_struct	*find_bar;

	/* Menus and Menu Items */
	GtkWidget	*recover_mi,
			*purge_mi,
			*purge_all_mi,
			*sync_recycle_bin_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_recover_mi,
			*edit_purge_mi,
			*edit_purge_all_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*chtime_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*contents_list_filter_mi,
			*contents_list_auto_resize_columns_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,

			*help_contents_mi,
			*help_recycle_bin_mi,
			*help_keys_list_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Contents clist right-click menu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_recover_mi,
			*contents_clist_purge_mi,
			*contents_clist_purge_all_mi,
			*contents_clist_rename_mi,
			*contents_clist_chmod_mi,
			*contents_clist_chown_mi,
			*contents_clist_chtime_mi,
			*contents_clist_properties_mi;

	gchar		*contents_list_filter;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;


	/* Status Bar */
	edv_status_bar_struct	*status_bar;

};


/* Utilities */
extern edv_recbin_opid_struct *EDVRecBinMatchOPID(
	edv_recbin_struct *recbin,
	const edv_recbin_op op
);

/* Title */
extern void EDVRecBinSetTitle(edv_recbin_struct *recbin);

/* Get selected object & paths */
extern GList *EDVRecBinGetSelectedObjectsList(
	edv_recbin_struct *recbin, 
	const gboolean copy
);

/* Regenerate Style, Menus, and Tool Bar */
extern void EDVRecBinAccelkeysRegenerate(edv_recbin_struct *recbin);
extern void EDVRecBinToolBarRegenerate(edv_recbin_struct *recbin);
extern void EDVRecBinContentsMenuRegenerate(edv_recbin_struct *recbin);

/* Sync Configuration */
extern void EDVRecBinSyncConfiguration(edv_recbin_struct *recbin);

/* Operation IDs */
extern GList *EDVRecBinOPIDListNew(edv_recbin_struct *recbin);
extern void EDVRecBinOPIDListDelete(GList *glist);

/* Accel Keys */
extern cfg_accelkey_list_struct *EDVRecBinAccelkeysListNewDefault(void);

/* Recycle Bin */
extern edv_recbin_struct *EDVRecBinNew(edv_core_struct *core);
extern void EDVRecBinSyncData(edv_recbin_struct *recbin);
extern void EDVRecBinUpdateMenus(edv_recbin_struct *recbin);
extern void EDVRecBinSetBusy(edv_recbin_struct *recbin, gboolean is_busy);
extern gboolean EDVRecBinIsMapped(edv_recbin_struct *recbin);
extern void EDVRecBinMap(edv_recbin_struct *recbin);
extern void EDVRecBinUnmap(edv_recbin_struct *recbin);
extern void EDVRecBinDelete(edv_recbin_struct *recbin);


#endif	/* RECBIN_H */
