/*
		     Endeavour User & Group ID Fetching
 */

#ifndef EDV_ID_GET_H
#define EDV_ID_GET_H

#include <glib.h>
#include "edv_id.h"
#include "edv_context.h"


/*
 *	Gets the UIDs list.
 *
 *	Returns a GList of edv_uid_struct * which must not be modified
 *	or deleted.
 */
extern GList *EDVUIDsList(edv_context_struct *ctx);

/*
 *	Gets the UID by user ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_id specifies the user ID.
 *
 *	Returns the UID or NULL on error.
 */
extern edv_uid_struct *EDVUIDMatchByUID(
	edv_context_struct *ctx,
	const gint user_id
);

/*
 *	Gets the UID by group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns the UID or NULL on error.
 */
extern edv_uid_struct *EDVUIDMatchByGID(
	edv_context_struct *ctx,
	const gint group_id
);

/*
 *	Gets the user ID from the user name.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_name specifies the string describing the user name.
 *
 *	Returns the user ID or negative on error.
 */
extern gint EDVUIDNameToUID(
	edv_context_struct *ctx,
	const gchar *user_name
);

/*
 *	Gets the user name or a string describing the user ID from the
 *	user ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The user_id specifies the user ID.
 *
 *	Returns a dynamically allocated string describing the user
 *	name or user ID or NULL on error.
 */
extern gchar *EDVUIDGetNameFromUID(
	edv_context_struct *ctx,
	const gint user_id
);

/*
 *	Gets the user name or a string describing the user ID from the
 *	group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns a dynamically allocated string describing the user
 *	name or user ID or NULL on error.
 */
extern gchar *EDVUIDGetNameFromGID(
	edv_context_struct *ctx,
	const gint group_id
);


/*
 *	Gets the GIDs list.
 *
 *	Returns a GList of edv_gid_struct * which must not be modified
 *	or deleted.
 */
extern GList *EDVGIDsList(edv_context_struct *ctx);

/*
 *	Gets the GID by group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns the GID or NULL on error.
 */
extern edv_gid_struct *EDVGIDMatchByGID(
	edv_context_struct *ctx,
	const gint group_id
);

/*
 *	Gets the group ID from the group name.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_name specifies the string describing the group name.
 *
 *	Returns the group ID or negative on error.
 */
extern gint EDVGIDNameToGID(
	edv_context_struct *ctx,
	const gchar *group_name
);

/*
 *	Gets the group name or a string describing the group ID from
 *	the group ID.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The group_id specifies the group ID.
 *
 *	Returns a dynamically allocated string describing the
 *	group name or group ID or NULL on error.
 */
extern gchar *EDVGIDGetNameFromGID(
	edv_context_struct *ctx,
	const gint group_id
);


#endif	/* EDV_ID_GET_H */
