#ifndef GIF_H
#define GIF_H

#ifdef HAVE_LIBGIF
#include <sys/types.h>

extern int ImgGIFReadRGBA(
        const char *filename,
        int *width_rtn, int *height_rtn, int *bpp_rtn, int *bpl_rtn,
        u_int8_t ***rgba_rtn, unsigned long **delay_list_rtn,
        int *nframes_rtn,
        u_int8_t *bg_color,	/* 4 bytes in RGBA format, will be modified */
        int *x_rtn, int *y_rtn,
        int *base_width_rtn, int *base_height_rtn,
        char **creator_rtn, char **title_rtn,
        char **author_rtn, char **comments_rtn,
        u_int8_t def_alpha_value,
        void *client_data,
        int (*progress_cb)(
                void *,		/* Client data */
                int, int,	/* Progress current & end values */
                int, int,	/* Width & height */
                int, int,	/* Bytes per line & bytes per pixel */
                u_int8_t *	/* RGBA data */
        ),
        int *user_aborted
);

#endif

#endif	/* GIF_H */
