/*
				Find Window
 */

#ifndef FIND_WIN_H
#define FIND_WIN_H

#include <gtk/gtk.h>
#include "pulist.h"
#include "edv_types.h"
#include "edv_status_bar.h"


typedef struct _edv_find_win_struct	edv_find_win_struct;
#define EDV_FIND_WIN(p)			((edv_find_win_struct *)(p))


/*
 *	Find Window Operations:
 */
typedef enum {
	EDV_FIND_WIN_FIND_BY_NAME,
	EDV_FIND_WIN_FIND_BY_CONTENT,
	EDV_FIND_WIN_FIND_BY_SIZE_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_SIZE_NOT_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_SIZE_LESS_THAN,
	EDV_FIND_WIN_FIND_BY_SIZE_GREATER_THAN,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_NOT_EQUAL_TO,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_LESS_THAN,
	EDV_FIND_WIN_FIND_BY_MODIFY_TIME_GREATER_THAN
} edv_find_win_find_by;


/*
 *	Maximum columns on the results clist:
 */
#define DEV_FINDWIN_RESULTS_LIST_COLUMNS_MAX	6

/*
 *	Find Window:
 */
struct _edv_find_win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		freeze_count,
			busy_count,
			stop_count;
	edv_core_struct *core;

	gboolean	status_bar_map_state;

	GtkWidget	*main_vbox;
	pulistbox_struct	*find_by_pulistbox;
	GtkWidget	*search_combo,
			*location_combo,
			*browse_location_btn,
			*case_sensitive_check,
			*recursive_check,
			*search_btn,
			*stop_btn,
			*clear_btn,
			*close_btn,
			*results_clist,
			*open_btn,
			*open_with_btn,
			*goto_btn;

	/* Results clist right click menu */
	GtkWidget	*results_clist_menu,
			*results_clist_open_mi,
			*results_clist_open_with_mi,
			*results_clist_goto_mi;

	/* Status Bar */
	edv_status_bar_struct	*status_bar;

	/* Reference to the window that created this find window
	 *
	 * Only of the indexes can be non-negative
	 */
	gint		browser_num,
			imbr_num,
			recbin_num,
			archiver_num;

	edv_location_type	location_type;

	edv_find_win_find_by	find_op;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;

};


extern const gchar *EDVFindWinCurrentSearch(edv_find_win_struct *fw);
extern void EDVFindWinSetSearch(
	edv_find_win_struct *fw,
	const gchar *s,
	const gboolean record_history
);

extern const gchar *EDVFindWinCurrentLocation(edv_find_win_struct *fw);
extern void EDVFindWinSetLocation(
	edv_find_win_struct *fw,
	const gchar *path,
	const gboolean record_history
);

extern edv_find_win_find_by EDVFindWinCurrentFindBy(
	edv_find_win_struct *fw
);

extern void EDVFindWinSetReferenceWindow(
	edv_find_win_struct *fw,
	const gint browser_num,
	const gint imbr_num,
	const gint recbin_num,
	const gint archive_num
);

extern void EDVFindWinListResetColumns(
	edv_find_win_struct *fw,
	const edv_find_win_find_by find_by
);
extern void EDVFindWinListAppend(
	edv_find_win_struct *fw,
	const gchar *path, struct stat *lstat_buf,
	const gchar *excerpt, const gint line_index
);
extern void EDVFindWinListClear(edv_find_win_struct *fw);

extern void EDVFindWinSyncConfiguration(edv_find_win_struct *fw);

extern edv_find_win_struct *EDVFindWinNew(edv_core_struct *core);
extern void EDVFindWinUpdateMenus(edv_find_win_struct *fw);
extern void EDVFindWinSetBusy(edv_find_win_struct *fw, const gboolean busy);
extern gboolean EDVFindWinIsMapped(edv_find_win_struct *fw);
extern void EDVFindWinMap(edv_find_win_struct *fw);
extern void EDVFindWinUnmap(edv_find_win_struct *fw);
extern void EDVFindWinDelete(edv_find_win_struct *fw);


#endif	/* FIND_WIN_H */
