#ifndef ARCHIVE_INFO_DLG_H
#define ARCHIVE_INFO_DLG_H

#include <gtk/gtk.h>
#include "pie_chart.h"
#include "edv_types.h"


typedef struct _edv_archive_info_dlg_struct	edv_archive_info_dlg_struct;
#define EDV_ARCHIVE_INFO_DLG(p)		((edv_archive_info_dlg_struct *)(p))


/*
 *	Archive Info Dialog:
 */
struct _edv_archive_info_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	has_changes;
	gint		freeze_count,
			busy_count;
	edv_core_struct *core;

	gchar		*arch_path;	/* Path to the archive that we are
					 * displaying the statistics and
					 * comments of */

	GdkCursor	*busy_cur;

	GtkWidget	*main_vbox,
			*icon_pm,
			*name_label,
			*location_label,
			*comment_text,
			*comment_set_btn,
			*comment_paste_btn,
			*comment_insert_file_btn,
			*ok_btn,
			*cancel_btn;

	pie_chart_struct	*piechart;

};


extern edv_archive_info_dlg_struct *EDVArchiveInfoNew(
	edv_core_struct *core,
	const gchar *arch_path,
	const gchar *password,
	GtkWidget *ref_toplevel
);
extern void EDVArchiveInfoSetHasChanges(
        edv_archive_info_dlg_struct *d, const gboolean has_changes
);
extern void EDVArchiveInfoUpdateMenus(edv_archive_info_dlg_struct *d);
extern void EDVArchiveInfoSetBusy(edv_archive_info_dlg_struct *d, const gboolean busy);
extern gboolean EDVArchiveInfoIsMapped(edv_archive_info_dlg_struct *d);
extern void EDVArchiveInfoMap(edv_archive_info_dlg_struct *d);
extern void EDVArchiveInfoUnmap(edv_archive_info_dlg_struct *d);
extern void EDVArchiveInfoDelete(edv_archive_info_dlg_struct *d);


#endif	/* ARCHIVE_INFO_DLG_H */
