
dnl AM_CHECK_ATOMIC(header-location, code-prefix, if-found)
AC_DEFUN([AM_CHECK_ATOMIC],
[
    AC_MSG_CHECKING([for atomic functions in $1])
    
    AC_TRY_LINK( [ #include <$1> ],
    [
	$2
	_Atomic_word i(0); 
	__atomic_add(&i, 1); 
	__exchange_and_add(&i, 1); 
    ], 
    [ 
	AC_MSG_RESULT(yes) 
	$3
    ], 
    [ 
	AC_MSG_RESULT(no) 
    ])
])

dnl If support is available, then HAVE_ATOMIC_GCC 
dnl will be set
dnl
AC_DEFUN([AM_ATOMIC],
[
    AC_ARG_ENABLE(atomic-gcc,
	AC_HELP_STRING([--enable-atomic-gcc],
	    [use gcc atomic instructions [default=test]]),
	enable_atomic_gcc=$enableval, enable_atomic_gcc="test" )

    ATOMIC_GCC="0"
    ATOMIC_GCC_PRIVATE="0"

    if test $enable_atomic_gcc != "no"; then
	dnl check bits directory for atomic functions
	AC_CHECK_HEADERS([bits/atomicity.h])
	if test "x$ac_cv_header_bits_atomicity_h" = xyes; then
	    AM_CHECK_ATOMIC([bits/atomicity.h], [], 
		[ATOMIC_GCC="1"])
	    
	    AM_CHECK_ATOMIC([bits/atomicity.h], [using namespace __gnu_cxx;], 
		[ATOMIC_GCC_PRIVATE="1"])
	fi

	dnl GCC 4.2 changed location to ext directory, so check that too
	AC_CHECK_HEADERS([ext/atomicity.h])
	if test "x$ac_cv_header_ext_atomicity_h" = xyes; then
	    AM_CHECK_ATOMIC([ext/atomicity.h], [], 
		[ATOMIC_GCC="1"])
	    
	    AM_CHECK_ATOMIC([ext/atomicity.h], [using namespace __gnu_cxx;], 
		[ATOMIC_GCC_PRIVATE="1"])
	fi

	if test "$ATOMIC_GCC" = "1"; then
	    AC_DEFINE(HAVE_ATOMIC_GCC,, 
		[Defined if atomicity.h is usable without namespace])
	fi

	if test "$ATOMIC_GCC_PRIVATE" = "1"; then
	    AC_DEFINE(HAVE_ATOMIC_GCC_PRIVATE,, 
		[Defined if atomicity.h is usable in __gnu_cxx namespace])
	fi
    fi
    
    AC_SUBST(ATOMIC_GCC)
    AC_SUBST(ATOMIC_GCC_PRIVATE)
])


