/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <memory.h>

void swap4_(char * version) {
/*
// Swaps the order of characters in experiment version (for little-endian)
//
// Called from FORTRAN:
//
//   CALL SWAP4(KSEC1(41))
*/
char copy[4];

  memcpy(copy,version,4);

  version[0] = copy[3];
  version[1] = copy[2];
  version[2] = copy[1];
  version[3] = copy[0];

  return;
}

void swap4(char * version) {
  swap4_(version);
}
