C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE GROUTPT()
C
C---->
C**** GROUTPT
C
C     Purpose.
C     --------
C     Changes diagnostic output stream if defined by environment variable.
C
C**   Interface.
C     ----------
C     CALL GROUTPT()
C
C
C     Input Parameters.
C     -----------------
C     None.
C
C
C     Output Parameters.
C     ------------------
C     None.
C
C
C     Method.
C     -------
C     Checks environment variable GRPRS_STREAM for output stream number
C     for printing (default is 6)
C
C
C     Externals.
C     ----------
C     Common block GRPRSCM.
C
C
C     Reference.
C     ----------
C     None.
C
C
C     Comments.
C     ---------
C     None.
C
C
C     Author.
C     -------
C
C     J.D.Chambers   ECMWF    June 2002
C
C----<
C     -----------------------------------------------------------------|
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------|
C
      IMPLICIT NONE
C
#include "grprs.h"
C
C
C     Local variables
C
      INTEGER IOFFSET
      CHARACTER*10 YNUMBER
C
C     -----------------------------------------------------------------|
C*    Section 1 .
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
C     See if output stream needs changing
C
      CALL GETENV('GRPRS_STREAM', YNUMBER)
      IOFFSET = INDEX( YNUMBER, ' ')
      IF( IOFFSET.GT.1 ) THEN
        IF( IOFFSET.EQ.2 ) THEN
          READ(YNUMBER,'(I1.1)') GRPRSM
        ELSE IF( IOFFSET.EQ.3 ) THEN
          READ(YNUMBER,'(I2.2)') GRPRSM
        ELSE
          WRITE(GRPRSM,*)
     X    'GROUTPT: Invalid value for GRPRS_STREAM: ' // YNUMBER
          GRPRSM = 6
        ENDIF
      ELSE
        GRPRSM = 6
      ENDIF
C
      IF( GRPRSM.LT.1 ) THEN
        WRITE(*,*) 'GROUTPT: Invalid number for GRPRS_STREAM: ', GRPRSM
        GRPRSM = 6
      ENDIF
C
C     -----------------------------------------------------------------|
C*    Section 9 . Format statements. Return to calling routine.
C     -----------------------------------------------------------------|
C
  900 CONTINUE
C
      RETURN
      END
