/*
  emilda-print
  Part of the Emilda project (http://www.emilda.org/)
	
  Copyright (C) 2003-2004 Realnode Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  
  Authors:
    Mattias Nordstrom <nordstrom (at) realnode.com>

  $Id: main.cpp,v 1.8 2004/02/23 11:23:25 matta Exp $
    This file provides the main function.

*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <stdio.h>
#include <gtk/gtk.h>

#include "dotconfpp.h"
#include "epd.h"
#include "print.h"

using namespace std;

void print_cmd_help(char *argv_0);

int main(int argc, char *argv[])
{
	cout << PACKAGE << " " << VERSION << " (" << __DATE__ << ")" << endl;
	cout << "Copyright (C) 2003-2004 Realnode Ltd\n\n";

	std::string argstr;
	
	if (argc == 2) {
		argstr = argv[1];
		if (argstr == "-h" || argstr == "--help") {
			print_cmd_help(argv[0]);
			return 0;
		}
	}
	
	DOTCONFDocument conf(DOTCONFDocument::CASEINSENSETIVE);
	
	#ifdef EMILDA_ETC
	#define EMILDA_CONF EMILDA_ETC "/emilda-print.conf"
	if (conf.setContent(EMILDA_CONF) == -1) {
	#else
	if (conf.setContent("emilda-print.conf") == -1) {
	#endif
		cerr << "ERROR: Couldn't read configuration file, aborting.\n";
		return 1;
	}
	
	GtkWidget *dlg_printing = NULL;
	
	if (gtk_init_check(NULL, NULL)) {
		dlg_printing = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_INFO,
                                  GTK_BUTTONS_NONE,
                                  "Printing document...");
		
		gtk_window_set_position(GTK_WINDOW(dlg_printing), GTK_WIN_POS_CENTER);
		gtk_window_set_resizable(GTK_WINDOW(dlg_printing), false);
		gtk_widget_show_all(dlg_printing);
		
		while (gtk_events_pending()) {
			gtk_main_iteration();
		}
	}

	int parse_result;
	epd epd_document;
	if (argc == 2) {
		ifstream input(argv[1], ios::binary & ios::in);
		parse_result = epd_document.parse_epd(&input);
		input.close();
	} else {
		parse_result = epd_document.parse_epd(&cin);
	}
	if (parse_result) {
		cerr << "EPD Parse Error: " << parse_result << endl;
		if (dlg_printing) {
			gtk_widget_destroy(dlg_printing);
			dlg_printing = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "An Error occured while parsing the EPD document!\nPlease make sure that you are using a valid EPD file, then try again.");

			gtk_window_set_position(GTK_WINDOW(dlg_printing), GTK_WIN_POS_CENTER);
			gtk_window_set_resizable(GTK_WINDOW(dlg_printing), false);
			gtk_dialog_run(GTK_DIALOG(dlg_printing));
			gtk_widget_destroy(dlg_printing);
		}
		return 1;
	}

	#ifdef DEBUG
	cout << "EPD Parse result: " << parse_result << endl;
	cout << "EPD Version: " << epd_document.document.version_ma << "." << epd_document.document.version_mi << endl;
	cout << "EPD Type: " << epd_document.document.type << endl;
	cout << "EPD Data:\n" << epd_document.document.data << endl;
	#endif

	if (print_epd(&epd_document, &conf)) {
		cerr << "ERROR: Couldn't print document.\n";
		if (dlg_printing) {
			gtk_widget_destroy(dlg_printing);
			dlg_printing = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "An Error occured while printing the document!\nPlease make sure that the printer is on and connected, then try again.");

			gtk_window_set_position(GTK_WINDOW(dlg_printing), GTK_WIN_POS_CENTER);
			gtk_window_set_resizable(GTK_WINDOW(dlg_printing), false);
			gtk_dialog_run(GTK_DIALOG(dlg_printing));
			gtk_widget_destroy(dlg_printing);
		}
		return 1;
	}
	
	if (dlg_printing) {
		sleep(2);
		gtk_widget_destroy(dlg_printing);
	}
	
	return 0;
}

void print_cmd_help(char *argv_0)
{
	cout << "Syntax: " << argv_0 << " [filename]\n";
	cout << "If no filename is given, " << PACKAGE << " reads the EPD document from stdin.\n\n";
}
