/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.graphics.Graph2DPlot;
import org.emboss.jemboss.gui.ImageIconJPanel;
import org.emboss.jemboss.gui.ResultsMenuBar;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;

public class ShowResultSet
extends JFrame {
    private ResultsMenuBar menuBar;
    private JTabbedPane rtp = new JTabbedPane();
    private JToolBar toolbar = null;

    public ShowResultSet(Hashtable reslist, String project, JembossParams mysettings) {
        this(reslist, null, project, mysettings);
    }

    public ShowResultSet(Hashtable reslist, Hashtable inputFiles) {
        this(reslist, inputFiles, null, null);
    }

    public ShowResultSet(Hashtable reslist, JembossParams mysettings) {
        this(reslist, null, null, mysettings);
    }

    public ShowResultSet(Hashtable reslist, Hashtable inputFiles, JembossParams mysettings) {
        this(reslist, inputFiles, null, mysettings);
    }

    public ShowResultSet(Hashtable reslist, Hashtable inputFiles, String project, JembossParams mysettings) {
        super("Saved Results - " + (project == null ? "" : project));
        JScrollPane r1;
        this.setDefaultCloseOperation(2);
        String prjdir = null;
        if (project != null) {
            prjdir = mysettings.getResultsHome() + project;
        }
        String[] stabs = this.addHashContentsToTab(reslist, this.rtp, prjdir, mysettings);
        if (inputFiles != null) {
            this.addHashContentsToTab(inputFiles, this.rtp, prjdir, mysettings);
        }
        for (int i = 0; i < stabs.length; ++i) {
            if (stabs[i].endsWith(".dat")) {
                Graph2DPlot gp = new Graph2DPlot();
                r1 = new JScrollPane(gp);
                gp.setFileData(new String((byte[])reslist.get(stabs[i])), stabs[i]);
                this.rtp.add((Component)r1, i);
                this.rtp.setTitleAt(i, stabs[i]);
                this.setJMenuBar(gp.getMenuBar(false, this));
                continue;
            }
            ImageIcon i1 = new ImageIcon((byte[])reslist.get(stabs[i]));
            ImageIconJPanel iiPanel = new ImageIconJPanel(i1);
            r1 = new JScrollPane(iiPanel);
            r1.getViewport().setBackground(Color.white);
            if (stabs[i] == null) continue;
            this.rtp.add((Component)r1, i);
            this.rtp.setTitleAt(i, stabs[i]);
        }
        String cmd = "cmd";
        if (reslist.containsKey(cmd)) {
            FileEditorDisplay fed = new FileEditorDisplay(cmd, reslist.get(cmd));
            fed.setCaretPosition(0);
            r1 = new JScrollPane(fed);
            this.rtp.add(cmd, r1);
        }
        this.menuBar = new ResultsMenuBar(this, this.rtp, reslist, inputFiles, project, mysettings);
        this.rtp.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ShowResultSet.this.setJMenuBar();
            }
        });
        this.setJMenuBar();
        this.setSize(640, 580);
        this.getContentPane().add((Component)this.rtp, "Center");
        this.setVisible(true);
    }

    public void setJMenuBar() {
        int index = this.rtp.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String title = this.rtp.getTitleAt(index);
        if (this.toolbar != null) {
            this.remove(this.toolbar);
        }
        if (title.endsWith(".dat")) {
            Graph2DPlot graph = this.getGraph2DPlot((JScrollPane)this.rtp.getSelectedComponent());
            if (graph == null) {
                return;
            }
            JMenuBar graphMenuBar = graph.getMenuBar(false, this);
            this.toolbar = graph.getToolBar();
            this.setJMenuBar(graphMenuBar);
        } else if (title.endsWith(".png")) {
            this.menuBar.getComponent(2).setEnabled(false);
            this.setJMenuBar(this.menuBar);
            this.toolbar = this.menuBar.getToolBar();
            this.toolbar.getComponent(0).setEnabled(false);
            this.toolbar.getComponent(2).setEnabled(false);
        } else {
            this.menuBar.getComponent(2).setEnabled(true);
            this.setJMenuBar(this.menuBar);
            this.toolbar = this.menuBar.getToolBar();
            this.toolbar.getComponent(0).setEnabled(true);
            this.toolbar.getComponent(2).setEnabled(true);
        }
        if (this.toolbar != null) {
            this.getContentPane().add((Component)this.toolbar, "North");
        }
    }

    private Graph2DPlot getGraph2DPlot(JScrollPane jsp) {
        Component comp = jsp.getViewport().getView();
        if (comp instanceof Graph2DPlot) {
            return (Graph2DPlot)comp;
        }
        return null;
    }

    private String[] addHashContentsToTab(Hashtable h, final JTabbedPane rtp, String prjdir, JembossParams settings) {
        String cmd = "cmd";
        Enumeration enumer = h.keys();
        String[] stabs = new String[h.size()];
        int ntabs = 0;
        while (enumer.hasMoreElements()) {
            JScrollPane r1;
            String thiskey = enumer.nextElement().toString();
            if (thiskey.equals(cmd)) continue;
            if (thiskey.endsWith("png") || thiskey.endsWith("html") || thiskey.endsWith(".dat")) {
                int index = this.findInt(thiskey);
                if (index > 0 && index < stabs.length) {
                    stabs[index - 1] = new String(thiskey);
                    ++ntabs;
                    continue;
                }
                ImageIcon i1 = new ImageIcon((byte[])h.get(thiskey));
                ImageIconJPanel iiPanel = new ImageIconJPanel(i1);
                r1 = new JScrollPane(iiPanel);
                r1.getViewport().setBackground(Color.white);
                rtp.add(thiskey, r1);
                continue;
            }
            if (thiskey.endsWith(".pdf") || thiskey.endsWith(".svg")) {
                Box box = new Box(1);
                Object obj = h.get(thiskey);
                if (settings.getDesktopSupportsOPENAction()) {
                    JButton bt = new JButton("Open using default desktop viewer");
                    String fname = prjdir != null ? prjdir + File.separator + thiskey : thiskey;
                    if (JembossParams.isJembossServer() || !new File(fname).exists()) {
                        try {
                            File tmpf = File.createTempFile("jemboss_", thiskey.substring(thiskey.lastIndexOf(46)));
                            FileOutputStream out = new FileOutputStream(tmpf);
                            if (obj instanceof byte[]) {
                                out.write((byte[])obj);
                            } else {
                                String s = (String)obj;
                                for (int i = 0; i < s.length(); ++i) {
                                    out.write(s.charAt(i));
                                }
                            }
                            out.close();
                            tmpf.deleteOnExit();
                            fname = tmpf.getAbsolutePath();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            fname = null;
                        }
                    }
                    if (fname != null) {
                        final String fname_ = fname;
                        bt.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    Desktop.getDesktop().open(new File(fname_));
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                    JOptionPane.showMessageDialog(rtp, ex.getMessage(), "Error", 0);
                                }
                            }
                        });
                        box.add(bt);
                    }
                }
                JTextArea ta = obj instanceof byte[] ? new JTextArea(new String((byte[])obj)) : new JTextArea((String)obj);
                ta.setEditable(false);
                r1 = new JScrollPane(ta);
                box.add(r1);
                rtp.add(thiskey, box);
                continue;
            }
            FileEditorDisplay fed = new FileEditorDisplay(thiskey, h.get(thiskey));
            fed.setCaretPosition(0);
            r1 = new JScrollPane(fed);
            rtp.add(thiskey, r1);
        }
        String[] pngtabs = new String[ntabs];
        for (int i = 0; i < ntabs; ++i) {
            pngtabs[i] = new String(stabs[i]);
        }
        return pngtabs;
    }

    private int findInt(String exp) {
        RECompiler rec = new RECompiler();
        try {
            REProgram rep = rec.compile("^(.*?)([:digit:]+)");
            RE regexp = new RE(rep);
            if (regexp.match(exp)) {
                int ia = new Integer(regexp.getParen(2));
                return ia;
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("RESyntaxException ");
        }
        return -1;
    }

    public class GroutPanelListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ShowResultSet.this.dispose();
        }
    }
}

