/* $Id: vars.h 2590 2005-12-05 20:20:10Z wojtekka $ */

/*
 *  (C) Copyright 2001-2002 Wojtek Kaniewski <wojtekka@irc.pl>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __VARS_H
#define __VARS_H

#include "dynstuff.h"

enum variable_type {
	VAR_STR,		/* cig znakw */
	VAR_INT,		/* liczba cakowita */
	VAR_BOOL,		/* 0/1, tak/nie, yes/no, on/off */
	VAR_FOREIGN,		/* nieznana zmienna */
	VAR_MAP			/* bitmapa */
};

struct value_map {
	int value;		/* warto */
	int conflicts;		/* wartoci, z ktrymi koliduje */
	char *label;		/* nazwa wartoci */
};

struct variable {
	char *name;		/* nazwa zmiennej */
	char short_name[3];	/* krtka nazwa zmiennej */
	int name_hash;		/* hash nazwy zmiennej */
	int type;		/* rodzaj */
	int display;		/* 0 bez wartoci, 1 pokazuje, 2 w ogle */
	void *ptr;		/* wskanik do zmiennej */
	void (*notify)(const char*);	/* funkcja wywoywana przy zmianie */
	struct value_map *map;	/* mapa wartoci i etykiet */
	int (*dyndisplay)(const char*);	/* funkcja sprawdzajca, czy wywietli zmienn na licie */
};

list_t variables;

void variable_init(void);
void variable_set_default(void);
struct variable *variable_find(const char *name);
struct value_map *variable_map(int count, ...);
int variable_add(const char *name, const char *short_name, int type, int display, void *ptr, void (*notify)(const char *name), struct value_map *map, int (*dyndisplay)(const char *name));
int variable_set(const char *name, const char *value, int allow_foreign);
char *variable_digest(void);
int variable_undigest(const char *digest);
void variable_help(const char *name);
void variable_free(void);

#endif /* __VARS_H */
