dnl Copyright (C) 2005-2008 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the COPYING file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_CGNS
#-----------------
# modifies or sets have_cgns, CGNS_CPPFLAGS, CGNS_LDFLAGS, and CGNS_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_CGNS], [

have_cgns=no

AC_ARG_ENABLE(cgns,
  [  --disable-cgns          do not use CGNS when available],
  [
    case "${enableval}" in
      yes) cgns=true ;;
      no)  cgns=false ;;
      *)   AC_MSG_ERROR([bad value ${enableval} for --enable-cgns]) ;;
    esac
  ],
  [ cgns=true ]
)

AC_ARG_WITH(cgns,
  [  --with-cgns=PATH        specify prefix directory for CGNS]
)

AC_ARG_WITH(cgns-include,
  [  --with-cgns-include=PATH  specify directory for CGNS include files]
)

AC_ARG_WITH(cgns-lib,
  [  --with-cgns-lib=PATH     specify directory for CGNS library]
)

if test "x$cgns" = "xtrue" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$with_cgns_include" != "x" ; then
    CGNS_CPPFLAGS="-I$with_cgns_include"
  elif test "x$with_cgns" != "x" ; then
    CGNS_CPPFLAGS="-I$with_cgns/include"
  fi

  if test "x$with_cgns_lib" != "x" ; then
    CGNS_LDFLAGS="-L$with_cgns_lib"
  elif test "x$with_cgns" != "x" ; then
    CGNS_LDFLAGS="-L$with_cgns/lib"
  fi

  CGNS_LIBS="-lcgns $HDF5_LIBS"
  CPPFLAGS="${CPPFLAGS} ${CGNS_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${CGNS_LDFLAGS} $HDF5_LDFLAGS"
  LIBS="${LIBS} ${CGNS_LIBS}"

  AC_CHECK_LIB(cgns, cg_open, 
               [ AC_DEFINE([HAVE_CGNS], 1, [CGNS file support])
                 have_cgns=yes
               ], 
               [ AC_MSG_WARN([no CGNS file support])
               ],
               )

  if test "x$have_cgns" != "xyes"; then
    CGNS_CPPFLAGS=""
    CGNS_LDFLAGS=""
    CGNS_LIBS=""
  fi

  CPPFLAGS="$saved_CPPFLAGS"
  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_CPPFLAGS
  unset saved_LDFLAGS
  unset saved_LIBS

fi

AM_CONDITIONAL(HAVE_CGNS, test x$have_cgns = xyes)

AC_SUBST(CGNS_CPPFLAGS)
AC_SUBST(CGNS_LDFLAGS)
AC_SUBST(CGNS_LIBS)

])dnl

