
import sys
import gtk
import time
import gobject
import os
from earcandy.earcandyconfig import getdatapath
from earcandy.util.Threads import threaded

class Client:
        def __init__(self, client, core):
            self.core = core
            self.client = client

            glade = os.path.join(getdatapath(), 'ui', 'EarCandy.ui')

            # Get glade file XML
            f = open( glade ,"r")
            xml =  f.read()
            f.close()
        
            # Remember you will need to recreate tree everytime the window loads
            #wtree = gtk.glade.xml_new_from_buffer(xml, len(xml), "table_clients")

            wtree = gtk.Builder()
            wtree.add_from_string(xml)

            self.gtk = wtree.get_object("table_clients") 
            self.gtk_progressbar_meter = wtree.get_object("progressbar_meter")   
            self.gtk_label = wtree.get_object("label_client_name")  
            self.gtk_icon = wtree.get_object("image_client_icon") 
            self.gtk_role_combobox = wtree.get_object("combobox_role") 
            self.button_client = wtree.get_object("button_client") 

            store = gtk.ListStore(gobject.TYPE_STRING)
            self.gtk_role_combobox.set_model(store)
            cell = gtk.CellRendererText()
            self.gtk_role_combobox.pack_start(cell, True)
            self.gtk_role_combobox.add_attribute(cell, 'text', 0)

            for key in self.core.display.keys():
                self.gtk_role_combobox.append_text(self.core.display[key])
            self.gtk_role_combobox.set_active(0)

            #client.gtk_role_combobox.set_model(self.cb_model)
            self.gtk_role_combobox.connect("changed", self.on_role_changed)
            self.button_client.connect("clicked", self.on_clicked)

            style = gtk.Style()
            self.gtk_label.modify_fg(gtk.STATE_NORMAL, style.fg[gtk.STATE_NORMAL])

            self.__hide_timer = False

            self.gtk.unparent()

        def on_clicked(self, widget):
            self.core.pref.open_client_properties(self.client)


        def on_role_changed(self, widget):
            #self.client.role = ""
            for key in self.core.display.keys():
                if self.core.display[key] == widget.get_active_text():
                    self.client.role = key
            self.core.save()
            return

        def set_status(self, status):
            if not status:
                if not self.__hide_timer:
                    self.__hide_timer = True
                    self.remove()
            else:
                self.__hide_timer = False

        @threaded
        def remove(self):
            count = 1
            while count < 60:
                if not self.__hide_timer: return
                time.sleep(1)
                count = count + 1
            if not self.client.is_active():
                self.gtk.hide()

