/////////////////////////////////////////////////////////////////////////////
// Name:        mediatrc_ffmpeg.h
// Purpose:     FFMPEG Media Transcoder
// Author:      Alex Thuering
// Created:     26.04.2008
// RCS-ID:      $Id: mediatrc_ffmpeg.h,v 1.29 2012/11/05 21:10:32 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_FFMPEG_MEDIA_TRANSCODER_H
#define WX_FFMPEG_MEDIA_TRANSCODER_H

#include "mediatrc.h"
#include <stdint.h>
#include <math.h>
#include <map>

class wxFfmpegMediaTranscoder : public wxMediaTranscoder {
public:
	wxFfmpegMediaTranscoder(int threadCount = 1);
	~wxFfmpegMediaTranscoder();
	static void Init();
	
	/** Adds input file. */
	bool AddInputFile(const wxString& fileName, bool disableVideo = false, bool disableAudio = false,
			bool disableSubtitle = false, long tsOffset = 0);
	
	/** Sets output file and video/audio/subtitle formats. */
	bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, AudioFormat audioFormat,
			SubtitleFormat subtitleFormat, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224,
			int mapStreamIdx = -1);
	/** Sets output file and video/audio/subtitle formats. */
	bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, wxArrayInt audioFormats,
			wxArrayInt subtitleFormats, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224,
			int mapStreamIdx = -1);
	/** Sets output format (optional). Call it before SetOutputFile() */
	void SetOutputFormat(wxString outputFormat) { m_outputFormat = outputFormat; }
	/** Sets interlaced encoding flag */
	void SetInterlaced(bool value);
	/** Sets first field flag (Auto, TFF, BFF) */
	void SetFirstField(FirstField firstField);
	/** Sets start time */
	void SetStartTime(double startTime);
	/** Sets recording time */
	void SetRecordingTime(double recordingTime);
	/** Sets video filters */
	void SetVideoFilters(const wxString& videoFilters) { m_videoFilters = videoFilters; }
	/** Sets audio volume (256=normal) */
	void SetAudioVolume(int streamIndex, int audioVolume) { m_audioVolume[streamIndex] = audioVolume; }
	/** Sets audio volume (256=normal) */
	void SetChannelNumber(int streamIndex, int channelNumber) { m_channelNumber[streamIndex] = channelNumber; }
	
	/** Starts transcoding. */
	bool Run(bool& canceled);
	/** Ends ttanscoding and closes all fiies. */
	void End();
	
	const wxString& GetCmd() const { return m_cmd; }
private:
	int m_threadCount;
	int m_inputFileCount;
	wxString m_cmd;
	wxString m_outputFormat;
	wxString m_videoFilters;
    map<int, int> m_audioVolume; // stream index -> audio volume
    map<int, int> m_channelNumber; // stream index -> channel number
    void AddOption(const wxString& name, const wxString& value);
    void AddAudioOption(const wxString& name, int streamIdx, const wxString& value);
    void AddVideoOption(const wxString& name, int streamIdx, const wxString& value);
};

#endif // WX_FFMPEG_MEDIA_TRANSCODER_H
