/////////////////////////////////////////////////////////////////////////////
// Name:        TitlePropDlg.h
// Purpose:     DVD title properties dialog
// Author:      Alex Thuering
// Created:     31.01.2004
// RCS-ID:      $Id: TitlePropDlg.h,v 1.19 2011/04/28 21:40:59 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef TITLE_PROP_DLG_H
#define TITLE_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include <wxVillaLib/Thumbnails.h>
#include "DVD.h"
#include "VobListBox.h"

class TitlePropDlg: public wxPropDlg {
public:
	TitlePropDlg(wxWindow *parent, DVD* dvd, int tsi, int pgci, int vobi);
	virtual ~TitlePropDlg();

	/** Returns list of commands for choice */
	static wxArrayString GetCommandList(DVD* dvd, int tsi);
private:
	DVD* m_dvd;
	int m_tsi;
	int m_pgci;
	PgcArray* m_pgcs;
	Pgc* m_pgc;
	Vob* m_vob;
	int m_vobi;
	wxArrayString* m_langCodes;
	VobListBox* m_vobListBox;
	wxCheckBox* m_doNotTranscodeCheckBox;
	wxBitmapButton* m_addBt;
	wxBitmapButton* m_delBt;
	wxBitmapButton* m_propBt;
	wxTextCtrl* m_chaptersCtrl;
	wxButton* m_chaptersBt;
	wxSpinCtrl* m_pause;
	wxThumbnails* m_slideShowBox;
	wxChoice* m_audioFormat;
	void CreatePropPanel(wxSizer* sizer);
	void CreateVobGroup(wxSizer* sizer);
	void CreateSlideshowGroup(wxSizer* sizer);
	void CreateAudioGroup(wxSizer* sizer);
	void CreateTitleGroup(wxSizer* sizer);
	bool SetValues();
	void OnSelectItem(wxCommandEvent& event);
	void OnAddBt(wxCommandEvent& event);
	void OnRemoveBt(wxCommandEvent& event);
	void OnPropBt(wxCommandEvent& event);
	void OnChaptersBt(wxCommandEvent& event);
	void OnChangeAudio(wxCommandEvent& event);
	void OnDoNotTranscodeCheck(wxCommandEvent& event);
	void UpdateDoNotTranscodeCheck();
	void UpdateChaptersCtrl();
	DECLARE_EVENT_TABLE()
};

#endif // TITLE_PROP_DLG_H
