// Standard Unix includes
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/time.h>

// The libs I use
#include <mysql/mysql.h>
#include <dotconf.h>
#include <auth-client.h>
#include <libesmtp.h>

// My includes
#include "message.h"	// Read stdin and message analysis
#include "log.h"
#include "global.h"	// loaded config file structure and extern stdin/out
#include "config_file.h"	// Lib-dot-conf loading and parsing functions
#include "my_strings.h"	// string manipulation (addSlashes() and so on)
#include "smtp.h"	// Lib esmtp send mail function
#include "sql_query.h"	// MySQL implementation
#include "bounce.h"
#include "exit.h"

// Error codes:
// 11 : address too long
// 31 : Permanentely refuse to send the message
// All other: temporary errors
// 51 : out of memeory
// 52 : timeout
// 53 : write error
// 55 : enable to read a configuration file
// 56 : problem to make a network connection from this host
// 61 : problem with the qmail home directory
// 62 : problem with the queue directory
// 63 : problem with the queue/pid directory
// 64 : problem with the queue/mess
// 65 : problem with the queue/intd
// 66 : problem with the queue/todo
// 71 : Mail  server  temporarily refuses to send the message to any recipients.
// 72 : Connection to mail server timed out.   (Not  used  by qmail-queue.)
// 73 : Connection  to  mail  server  rejected.  (Not used by qmail-queue.)
// 74 : Connection to mail server succeeded,  but  communication failed.  (Not used by qmail-queue.)
// 81 : Internal bug; e.g., segmentation fault.
// 91 : Envelope format error.

int main(int argc,char* argv[]){
	long i;
	tErr err;
	tMsg* msg;	// The incoming message object (parsed from stdin)
	LOG("Reading conf file...........");
	read_config_file();
	LOG("done!\n");

	LOG("Connecting to mysql.........");
	do_ze_mysql_connect();
	LOG("done!\n");

 
 	LOG("Parsing message header......");
	msg = new tMsg();
	err = msg->init();
	LOG("done!\n");
	if(err != noErr){
//		LOG("Error while parsing header.");
		fprintf(stderr,"[igw]DENY: BAD HEADER\n");
		exit(EXIT_PARSE_HEADER_ERROR);
	}
	LOG("Checking from field.........");
	if(strstr(msg->m_head->m_From_feild,"iglobalwalldaemon@iglobalwall.com") != 0){
		LOG("[igw]Accepting message: from spam daemon.");
		exit(0);
	}

	if(strstr(msg->m_head->m_From_feild,"root@tamere.com") != 0){
		LOG("[igw]Accepting message: from spam daemon.");
		exit(0);
	}else{
//		LOG("not from igwdaemon\n");
	}

	msg->m_head->m_fetchmail_email_addr = findRetrivedMailbox(&msg->m_head->m_iWall_user,msg->m_head->m_fetchmail_username,msg->m_head->m_fetchmail_server_addr);
//	printf("email:'%s'user:'%s'\n", msg->m_head->m_fetchmail_email_addr, msg->m_head->m_iWall_user);
	if(msg->m_head->m_fetchmail_email_addr == NULL){
		fprintf(stderr,"[igw]Deny:No mailbox found in db.\n");
		exit(1);
		return 1;
	}
//	fprintf(stderr,"[igw]login:%s/srv:%s/from:%s/\n",
//msg->m_head->m_fetchmail_username,msg->m_head->m_fetchmail_server_addr,msg->m_head->m_From_feild);
	if(isInWhitelist(msg->m_head->m_iWall_user,msg->m_head->m_fetchmail_email_addr,msg->m_head->m_from_user,msg->m_head->m_from_domain)!=NULL){
		LOG("[igw]Accepting message: from address recognised in whitelist.\n");
		fprintf(stderr,"[igw]ACCEPT: FROM IS IN WHITELIST\n");
		exit(0);
	}
	LOG("done!\n");

	LOG("Checking to field...........");
	for(i=0;i<msg->m_head->m_nbr_rcpt;i++){
		if(isInTolist(msg->m_head->m_iWall_user,msg->m_head->m_fetchmail_email_addr,msg->m_head->m_rcpt[i]) != NULL){
			LOG("[igw]Accepting message: from address recognised in tolist.\n");
			fprintf(stderr,"[igw]ACCEPT: FROM IS IN WHITELIST\n");
			exit(0);
		}
	}
	LOG("done!\n");

	LOG("Bouncing message............");
	bounceMessage(msg);
	LOG("done!\n");
	fprintf(stderr,"[igw]DENY: FROM NOT IN WHITELIST\n");
	exit(EXIT_NOT_IN_WHITELIST);
}
