/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.APIAdapterApplet;
import org.adl.util.debug.DebugIndicator;

public class CMILaunchData
extends CMICategory
implements Serializable {
    public Element launch_data;

    public CMILaunchData(String launchData) {
        super(false);
        this.launch_data = new Element(launchData, "checkString4096", "NULL", false, true, true);
    }

    public CMILaunchData() {
        super(false);
        this.launch_data = new Element("", "checkString4096", "NULL", false, true, true);
    }

    public Element getLaunchData() {
        return this.launch_data;
    }

    public void setLaunchData(String inLaunchData) {
        this.launch_data.setValue(inLaunchData);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + theRequest.getRequest() + "is not a valid element of the CMI Launch Data\n" + "Data Model Category");
            }
            if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            } else {
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else {
            result = this.launch_data.getValue();
        }
        theRequest.done();
        return result;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (APIAdapterApplet.areweloading) {
            if (!theRequest.hasMoreTokensToProcess()) {
                String content = theRequest.getValue();
                if (content.length() <= 4096) {
                    String currentlaunchdata = this.launch_data.getValue();
                    this.launch_data.setValue(content);
                } else {
                    if (DebugIndicator.ON) {
                        System.out.println("***** INVALID DURING LOADING LMSSetValue() CALL *****");
                        System.out.println("             Invalid Type             ");
                        System.out.println("         Element was not set!         ");
                    }
                    dmErrorMgr.SetCurrentErrorCode("405");
                }
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Data Model Element not implemented");
                    System.out.println("Element being processed: " + theRequest.getElement() + "is not a valid data model element.\n");
                }
                dmErrorMgr.recNotImplementedError(theRequest);
            }
            theRequest.done();
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Invalid LMSSetValue() request: " + theRequest.getRequest());
                System.out.println("Assignable Unit is not permitted to call LMSSetValue() for cmi.launch_data");
            }
            dmErrorMgr.SetCurrentErrorCode("403");
        }
    }
}

