import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class Yirmumah(BasicComicModule):
    latestUrl = 'http://www.yirmumah.djcoffman.com/'
    imageUrl = 'http://yirmumah.net/archives.php?date=%s'
    imageSearch = re.compile(r'"(.+/strips/.*?)"', re.IGNORECASE)
    prevSearch = re.compile(r'"(http://www.yirmumah.net/.*?)">.*?previous', re.IGNORECASE)
    help = 'Index format: yyyymmdd'
    
    
    def getFilename(self, imageUrl, pageUrl):
        name = imageUrl.split('/')[-1].split('.')[0]
        return name[-8:]+'_'+name[:-8]