# Copyright (C) 2009 Hans Petter Langtangen
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN.  If not, see <http://www.gnu.org/licenses/>.
#
# Modified by Anders Logg, 2009.
#
# First added:  2009-12-14
# Last changed: 2010-02-14

class DoNothing(object):
    """
    This class is a generic dispatcher, accepting anyting and doing
    nothing. It can be used in places where certain functionality like
    plotting should be disabled without requiring changes to existing
    code.

    Whatever we do, we always get a DoNothing object, with which we can
    do whater we want to, but nothing will ever happen.
    """

    def __init__(self, *args, **kwargs):
        pass

    def __call__(self, *args, **kwargs):
        return DoNothing()

    def __repr__(self):
        return ""

    def __str__(self):
        return repr(self)

    def __getattribute__(self, name):
        print "Ignoring call to %s" % name
        return DoNothing()
