/*
 *  Remote Network application system for DNAS -- utiliti funcs
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: utility.c,v 1.2 2002/11/17 14:25:24 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include <dlfcn.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

/** 
 * get lisp text for nth entry
 *
 * @return const char pointer, no need to free.
 */
const char * 
getnthlisp(dlisp_lispentry* l, int n)
{
  int i;
  
  for (i=0; i< n ; ++ i)
    {
      if (!(l && (l=l->next)))
	{
	  fprintf(stderr, "Warning: no %i entry on lisp data\n", n);
	  return NULL;
	}
      
    }
  return l->name;
}

/** 
 * require n parameters for lisp data.
 *
 * @return 1 on failure.
 */
int
require_lisp_params(dlisp_lispentry* l, int n)
{
  int i;
  
  for (i=0; i< n ; ++ i)
    {
      if (!(l && (l=l->next)))
	{
	  return 1;
	}
      
    }
  return 0;
}
