/*
 *  Remote Network application system for DNAS -- plugin for generation display
 *  Copyright (C) 2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: rnasmonitor-generation.c,v 1.5 2002/09/28 11:55:11 dancer Exp $
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <pthread.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <locale.h>
#include "config.h"
#include "dmachinemon/dmachinemon-debug.h"
#include "dmachinemon/dmachinemon.h"
#include "dmachinemon/libsocket.h"
#include "dmachinemon/dmachinemon-libdatabase.h"
#include "dmachinemon/dmachinemon-commandlineparser.h"
#include "rnas-monitor-gtk.h"

int
rnas_monitor_initialize (rnasmonitors * r)
{
  printf("$Id: rnasmonitor-generation.c,v 1.5 2002/09/28 11:55:11 dancer Exp $\n");
  INITIALIZE_RNASMONITOR(r);

  if (require_lisp_params(r->l, 3))
    {
      fprintf(stderr, "This plugin requires: \n"
	      "SO, title, TAG MAX-generation");
      return 1;
    }
  if (atof(getnthlisp(r->l,3)) <0)
    {
      fprintf(stderr, "This plugin requires: \n"
	      "a positive value for MAX-generation");
      return 1;
    }
  return 0;
}

static GtkWidget* 
create_window_new(const char * hostname, GtkWidget * hbox, rnasmonitors* r, rnas_applicationdata *m)
{
  GtkWidget * w = gtk_progress_bar_new();
  
  gtk_progress_bar_set_bar_style(GTK_PROGRESS_BAR (w), GTK_PROGRESS_CONTINUOUS);
  gtk_progress_set_format_string(GTK_PROGRESS(w), "%v/%u");
  gtk_progress_set_show_text(GTK_PROGRESS(w), TRUE);
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, FALSE);
  gtk_widget_show(w);
  return w;
}

static int
displayfunction(struct rnas_applicationdata* m, dm_machinelist* dm)
{
  float value=dm_get_value_float (dm, getnthlisp(m->r->l,2)); /* get the third parameter  */
  float maxval = atof(getnthlisp(m->r->l,3));

  if (maxval < value)
    maxval = value;
  
  gtk_progress_configure(GTK_PROGRESS(m->w), value, 0.0, maxval);
  return 0;
}

