/*
 *  dmachinemon / a distributed machine monitor by dancer.
 *  Copyright (C) 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Routing info library.
 */

#ifndef __DMACHINEMON_SERVENT_LIBROUTE_H__
#define __DMACHINEMON_SERVENT_LIBROUTE_H__

#include <dmachinemon/dmachinemon-libdatabase.h>
#include <dmachinemon/dmachinemon-commandlineparser.h>

int dm_obtain_route (int socket, int check_loops_in_route_flag, const char * current_uplink);
void dm_send_route (int socket, const dm_commandoption * cdat);
char * dm_get_route (void);
void dm_wait_route_get(void);
char * dm_obtain_uplink_host (void);
char * dm_obtain_grandparent_host(void);
int dm_remove_last_route_to(void);
void dm_randomly_change_route_to (dm_machinelist_information * m, const dm_commandoption * cdat);

char *dm_get_lastitem (const char * ch);
char *dm_get_firstitem (const char * ch);
char *dm_get_itemsexceptlast (const char * ch);
char *dm_get_itemsexceptfirst (const char * ch);





#endif

