﻿/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * ironruby@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using System.Collections.ObjectModel;
using System.Linq.Expressions;
using System.Runtime.CompilerServices;
using IronRuby.Builtins;

namespace IronRuby.Runtime.Calls {
    public abstract partial class MethodDispatcher {
        internal const int /*$$*/MaxPrecompiledArity = 5;
        internal const int /*$$*/MaxInterpretedArity = 15;

        private static readonly Type[] RubyObjectMethodDispatchers = new[] {
#if GENERATOR
            def generate; add_generic_types($MaxPrecompiledArity); end
#else
            typeof(RubyObjectMethodDispatcher<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(RubyObjectMethodDispatcher<,>),
            typeof(RubyObjectMethodDispatcher<,,>),
            typeof(RubyObjectMethodDispatcher<,,,>),
            typeof(RubyObjectMethodDispatcher<,,,,>),
#endregion
        };

        private static readonly Type[] RubyObjectMethodDispatchersWithBlock = new[] {
#if GENERATOR
            def generate; add_generic_types($MaxPrecompiledArity); end
#else
            typeof(RubyObjectMethodDispatcherWithBlock<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(RubyObjectMethodDispatcherWithBlock<,>),
            typeof(RubyObjectMethodDispatcherWithBlock<,,>),
            typeof(RubyObjectMethodDispatcherWithBlock<,,,>),
            typeof(RubyObjectMethodDispatcherWithBlock<,,,,>),
#endregion
        };

        private static readonly Type[] RubyObjectMethodDispatchersWithScope = new[] {
#if GENERATOR
            def generate; add_generic_types($MaxPrecompiledArity); end
#else
            typeof(RubyObjectMethodDispatcherWithScope<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(RubyObjectMethodDispatcherWithScope<,>),
            typeof(RubyObjectMethodDispatcherWithScope<,,>),
            typeof(RubyObjectMethodDispatcherWithScope<,,,>),
            typeof(RubyObjectMethodDispatcherWithScope<,,,,>),
#endregion
        };

        private static readonly Type[] RubyObjectMethodDispatchersWithScopeAndBlock = new[] {
#if GENERATOR
            def generate; add_generic_types($MaxPrecompiledArity); end
#else
            typeof(RubyObjectMethodDispatcherWithScopeAndBlock<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(RubyObjectMethodDispatcherWithScopeAndBlock<,>),
            typeof(RubyObjectMethodDispatcherWithScopeAndBlock<,,>),
            typeof(RubyObjectMethodDispatcherWithScopeAndBlock<,,,>),
            typeof(RubyObjectMethodDispatcherWithScopeAndBlock<,,,,>),
#endregion
        };

        private static readonly Type[] InterpretedFuncDispatchers = new[] {
#if GENERATOR
            def generate; add_generic_types($MaxInterpretedArity + 1); end
#else
            typeof(InterpretedFuncDispatcher<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(InterpretedFuncDispatcher<,>),
            typeof(InterpretedFuncDispatcher<,,>),
            typeof(InterpretedFuncDispatcher<,,,>),
            typeof(InterpretedFuncDispatcher<,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,,,,,>),
            typeof(InterpretedFuncDispatcher<,,,,,,,,,,,,,,,>),
#endregion
        };

        private static readonly Type[] InterpretedActionDispatchers = new[] {
            typeof(InterpretedActionDispatcher),
#if GENERATOR
            def generate; add_generic_types($MaxInterpretedArity); end
#else
            typeof(InterpretedActionDispatcher<>),
#endif
#region Generated by MethodDispatcher.Generator.rb
            typeof(InterpretedActionDispatcher<,>),
            typeof(InterpretedActionDispatcher<,,>),
            typeof(InterpretedActionDispatcher<,,,>),
            typeof(InterpretedActionDispatcher<,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,,,,,>),
            typeof(InterpretedActionDispatcher<,,,,,,,,,,,,,,>),
#endregion
        };
    }

#if GENERATOR
    def generate
      $MaxPrecompiledArity.times { |n| @n = n + 1; super }
    end
#else
    public class RubyObjectMethodDispatcher/*$GenericDecl*/ : MethodDispatcher<Func<object, Proc, object/*$Objects*/>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object /*$GenericParams*/, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self /*$Parameters*/) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null /*$Arguments*/);
            } else {
                return ((CallSite<Func<CallSite, object /*$GenericParams*/, object>>)callSite).
                    Update(callSite, self /*$Arguments*/);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope/*$GenericDecl*/ : MethodDispatcher<Func<object, Proc, object/*$Objects*/>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object /*$GenericParams*/, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self /*$Parameters*/) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null /*$Arguments*/);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object /*$GenericParams*/, object>>)callSite).
                    Update(callSite, scope, self /*$Arguments*/);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock/*$GenericDecl*/ : MethodDispatcher<Func<object, Proc, object/*$Objects*/>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc /*$GenericParams*/, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc /*$Parameters*/) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc /*$Arguments*/);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc /*$GenericParams*/, object>>)callSite).
                    Update(callSite, self, proc /*$Arguments*/);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock/*$GenericDecl*/ : MethodDispatcher<Func<object, Proc, object/*$Objects*/>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc /*$GenericParams*/, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc /*$Parameters*/) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc /*$Arguments*/);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc /*$GenericParams*/, object>>)callSite).
                    Update(callSite, scope, self, proc /*$Arguments*/);
            }
        }
    }
#endif
#region Generated by MethodDispatcher.Generator.rb
    public class RubyObjectMethodDispatcher<T0> : MethodDispatcher<Func<object, Proc, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object , T0, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self ,T0 arg0) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0);
            } else {
                return ((CallSite<Func<CallSite, object , T0, object>>)callSite).
                    Update(callSite, self ,arg0);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope<T0> : MethodDispatcher<Func<object, Proc, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object , T0, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self ,T0 arg0) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object , T0, object>>)callSite).
                    Update(callSite, scope, self ,arg0);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock<T0> : MethodDispatcher<Func<object, Proc, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc , T0, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc ,T0 arg0) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc , T0, object>>)callSite).
                    Update(callSite, self, proc ,arg0);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock<T0> : MethodDispatcher<Func<object, Proc, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc , T0, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc ,T0 arg0) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc , T0, object>>)callSite).
                    Update(callSite, scope, self, proc ,arg0);
            }
        }
    }
    public class RubyObjectMethodDispatcher<T0, T1> : MethodDispatcher<Func<object, Proc, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object , T0 , T1, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self ,T0 arg0, T1 arg1) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1);
            } else {
                return ((CallSite<Func<CallSite, object , T0 , T1, object>>)callSite).
                    Update(callSite, self ,arg0, arg1);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope<T0, T1> : MethodDispatcher<Func<object, Proc, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object , T0 , T1, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self ,T0 arg0, T1 arg1) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object , T0 , T1, object>>)callSite).
                    Update(callSite, scope, self ,arg0, arg1);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock<T0, T1> : MethodDispatcher<Func<object, Proc, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc , T0 , T1, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc ,T0 arg0, T1 arg1) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc , T0 , T1, object>>)callSite).
                    Update(callSite, self, proc ,arg0, arg1);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock<T0, T1> : MethodDispatcher<Func<object, Proc, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc , T0 , T1, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc ,T0 arg0, T1 arg1) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc , T0 , T1, object>>)callSite).
                    Update(callSite, scope, self, proc ,arg0, arg1);
            }
        }
    }
    public class RubyObjectMethodDispatcher<T0, T1, T2> : MethodDispatcher<Func<object, Proc, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object , T0 , T1 , T2, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self ,T0 arg0, T1 arg1, T2 arg2) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2);
            } else {
                return ((CallSite<Func<CallSite, object , T0 , T1 , T2, object>>)callSite).
                    Update(callSite, self ,arg0, arg1, arg2);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope<T0, T1, T2> : MethodDispatcher<Func<object, Proc, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object , T0 , T1 , T2, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self ,T0 arg0, T1 arg1, T2 arg2) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object , T0 , T1 , T2, object>>)callSite).
                    Update(callSite, scope, self ,arg0, arg1, arg2);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock<T0, T1, T2> : MethodDispatcher<Func<object, Proc, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc , T0 , T1 , T2, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc , T0 , T1 , T2, object>>)callSite).
                    Update(callSite, self, proc ,arg0, arg1, arg2);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock<T0, T1, T2> : MethodDispatcher<Func<object, Proc, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2, object>>)callSite).
                    Update(callSite, scope, self, proc ,arg0, arg1, arg2);
            }
        }
    }
    public class RubyObjectMethodDispatcher<T0, T1, T2, T3> : MethodDispatcher<Func<object, Proc, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object , T0 , T1 , T2 , T3, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self ,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2, arg3);
            } else {
                return ((CallSite<Func<CallSite, object , T0 , T1 , T2 , T3, object>>)callSite).
                    Update(callSite, self ,arg0, arg1, arg2, arg3);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope<T0, T1, T2, T3> : MethodDispatcher<Func<object, Proc, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object , T0 , T1 , T2 , T3, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self ,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2, arg3);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object , T0 , T1 , T2 , T3, object>>)callSite).
                    Update(callSite, scope, self ,arg0, arg1, arg2, arg3);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock<T0, T1, T2, T3> : MethodDispatcher<Func<object, Proc, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc , T0 , T1 , T2 , T3, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2, arg3);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc , T0 , T1 , T2 , T3, object>>)callSite).
                    Update(callSite, self, proc ,arg0, arg1, arg2, arg3);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock<T0, T1, T2, T3> : MethodDispatcher<Func<object, Proc, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2 , T3, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2, arg3);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2 , T3, object>>)callSite).
                    Update(callSite, scope, self, proc ,arg0, arg1, arg2, arg3);
            }
        }
    }
    public class RubyObjectMethodDispatcher<T0, T1, T2, T3, T4> : MethodDispatcher<Func<object, Proc, object, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object , T0 , T1 , T2 , T3 , T4, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self ,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2, arg3, arg4);
            } else {
                return ((CallSite<Func<CallSite, object , T0 , T1 , T2 , T3 , T4, object>>)callSite).
                    Update(callSite, self ,arg0, arg1, arg2, arg3, arg4);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScope<T0, T1, T2, T3, T4> : MethodDispatcher<Func<object, Proc, object, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object , T0 , T1 , T2 , T3 , T4, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self ,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                return Method(self, null ,arg0, arg1, arg2, arg3, arg4);
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object , T0 , T1 , T2 , T3 , T4, object>>)callSite).
                    Update(callSite, scope, self ,arg0, arg1, arg2, arg3, arg4);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithBlock<T0, T1, T2, T3, T4> : MethodDispatcher<Func<object, Proc, object, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, object, Proc , T0 , T1 , T2 , T3 , T4, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2, arg3, arg4);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, object, Proc , T0 , T1 , T2 , T3 , T4, object>>)callSite).
                    Update(callSite, self, proc ,arg0, arg1, arg2, arg3, arg4);
            }
        }
    }

    public class RubyObjectMethodDispatcherWithScopeAndBlock<T0, T1, T2, T3, T4> : MethodDispatcher<Func<object, Proc, object, object, object, object, object, object>> {
        public override object/*!*/ CreateDelegate() {
            return new Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2 , T3 , T4, object>(Invoke);
        }

        public object Invoke(CallSite/*!*/ callSite, RubyScope/*!*/ scope, object self, Proc proc ,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            IRubyObject obj = self as IRubyObject;
            if (obj != null && obj.ImmediateClass.Version.Value == Version) {
                // see RubyMethodInfo.cs: RuleControlFlowBuilder
                var rfc = RubyOps.CreateRfcForMethod(proc);
                try {
                    return Method(self, proc ,arg0, arg1, arg2, arg3, arg4);
                } catch (MethodUnwinder unwinder) {
                    if (unwinder.TargetFrame == rfc) {
                        return unwinder.ReturnValue;
                    } else {
                        throw;
                    }
                } finally {
                    rfc.LeaveMethod();
                }
            } else {
                return ((CallSite<Func<CallSite, RubyScope, object, Proc , T0 , T1 , T2 , T3 , T4, object>>)callSite).
                    Update(callSite, scope, self, proc ,arg0, arg1, arg2, arg3, arg4);
            }
        }
    }
#endregion

#if GENERATOR
    def generate
      $MaxInterpretedArity.times { |n| @n = n + 1; super }
    end
#else
    public class InterpretedFuncDispatcher/*$GenericDeclWithReturn{*/<TReturn>/*}*/ : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                /*$ParameterExpressions*/                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite /*$GenericParams*/, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite/*$Parameters*/) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite /*$GenericParams*/, TReturn>>)callSite).Target = (Func<CallSite /*$GenericParams*/, TReturn>)_compiled;
            }
            return ((Func<CallSite /*$GenericParams*/, TReturn>)_rule)(callSite /*$Arguments*/);
        }
    }

    public class InterpretedActionDispatcher/*$GenericDecl*/ : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                /*$ParameterExpressions*/                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite/*$GenericParams*/>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite/*$Parameters*/) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite/*$GenericParams*/>>)callSite).Target = (Action<CallSite/*$GenericParams*/>)_compiled;
            }
            ((Action<CallSite/*$GenericParams*/>)_rule)(callSite /*$Arguments*/);
        }
    }
#endif
#region Generated by MethodDispatcher.Generator.rb
    public class InterpretedFuncDispatcher<T0, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0, TReturn>>)callSite).Target = (Func<CallSite , T0, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0, TReturn>)_rule)(callSite ,arg0);
        }
    }

    public class InterpretedActionDispatcher<T0> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0>>)callSite).Target = (Action<CallSite, T0>)_compiled;
            }
            ((Action<CallSite, T0>)_rule)(callSite ,arg0);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1, TReturn>)_rule)(callSite ,arg0, arg1);
        }
    }

    public class InterpretedActionDispatcher<T0, T1> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1>>)callSite).Target = (Action<CallSite, T0 , T1>)_compiled;
            }
            ((Action<CallSite, T0 , T1>)_rule)(callSite ,arg0, arg1);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2, TReturn>)_rule)(callSite ,arg0, arg1, arg2);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2>>)callSite).Target = (Action<CallSite, T0 , T1 , T2>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2>)_rule)(callSite ,arg0, arg1, arg2);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3>)_rule)(callSite ,arg0, arg1, arg2, arg3);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12"), Expression.Parameter(typeof(T13), "$arg13")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12"), Expression.Parameter(typeof(T13), "$arg13")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
        }
    }
    public class InterpretedFuncDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, TReturn> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12"), Expression.Parameter(typeof(T13), "$arg13"), Expression.Parameter(typeof(T14), "$arg14")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(TReturn));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14, TReturn>(Invoke);
        }

        public TReturn Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14) {
            if (_compiled != null) {
                ((CallSite<Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14, TReturn>>)callSite).Target = (Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14, TReturn>)_compiled;
            }
            return ((Func<CallSite , T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14, TReturn>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
        }
    }

    public class InterpretedActionDispatcher<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> : InterpretedDispatcher {
        internal static readonly ReadOnlyCollection<ParameterExpression> _Parameters =
            new ReadOnlyCollection<ParameterExpression>(new ParameterExpression[] {
                Expression.Parameter(typeof(T0), "$arg0"), Expression.Parameter(typeof(T1), "$arg1"), Expression.Parameter(typeof(T2), "$arg2"), Expression.Parameter(typeof(T3), "$arg3"), Expression.Parameter(typeof(T4), "$arg4"), Expression.Parameter(typeof(T5), "$arg5"), Expression.Parameter(typeof(T6), "$arg6"), Expression.Parameter(typeof(T7), "$arg7"), Expression.Parameter(typeof(T8), "$arg8"), Expression.Parameter(typeof(T9), "$arg9"), Expression.Parameter(typeof(T10), "$arg10"), Expression.Parameter(typeof(T11), "$arg11"), Expression.Parameter(typeof(T12), "$arg12"), Expression.Parameter(typeof(T13), "$arg13"), Expression.Parameter(typeof(T14), "$arg14")                
            });

        internal static readonly LabelTarget _ReturnLabel = Expression.Label(typeof(void));

        internal override ReadOnlyCollection<ParameterExpression> Parameters { get { return _Parameters; } }
        internal override LabelTarget ReturnLabel { get { return _ReturnLabel; } }

        internal override object/*!*/ GetInterpretingDelegate() {
            return new Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14>(Invoke);
        }

        public void Invoke(CallSite/*!*/ callSite,T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14) {
            if (_compiled != null) {
                ((CallSite<Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14>>)callSite).Target = (Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14>)_compiled;
            }
            ((Action<CallSite, T0 , T1 , T2 , T3 , T4 , T5 , T6 , T7 , T8 , T9 , T10 , T11 , T12 , T13 , T14>)_rule)(callSite ,arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
        }
    }
#endregion
}

