/*
**  Copyright (c) 2004, 2005, 2007, 2008 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: util.h,v 1.23 2008/11/10 07:01:51 msk Exp $
*/

#ifndef _UTIL_H_
#define _UTIL_H_

#ifndef lint
static char util_h_id[] = "@(#)$Id: util.h,v 1.23 2008/11/10 07:01:51 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>

/* libsm includes */
#include <sm/gen.h>

#ifdef POPAUTH
/* libdb includes */
# include <db.h>
#endif /* POPAUTH */

/* dkim-filter includes */
#include "dkim-filter.h"

/* TYPES */
struct dkimf_dstring;

#ifdef _FFR_REPLACE_RULES
/*
**  REPLACE -- replacement table
*/

struct replace
{
	regex_t		repl_re;
	char *		repl_txt;
	struct replace	*repl_next;
};
#endif /* _FFR_REPLACE_RULES */

/* PROTOTYPES */
extern void dkimf_base64_encode_file __P((int, FILE *, int, int, int));
extern bool dkimf_checkhost __P((Peer, char *));
extern bool dkimf_checkip __P((Peer, struct sockaddr *));
#ifdef POPAUTH
extern bool dkimf_checkpopauth __P((DB *, struct sockaddr *));
#endif /* POPAUTH */
#ifdef _FFR_COMMAIZE
extern int dkimf_commaize __P((struct dkimf_dstring *, char *,
                               size_t, size_t, bool));
#endif /* _FFR_COMMAIZE */
extern void dkimf_free_list __P((struct Peer *));
extern bool dkimf_hostlist __P((char *, char **));
extern size_t dkimf_inet_ntoa __P((struct in_addr, char *, size_t));
#ifdef POPAUTH
extern int dkimf_initpopauth __P((void));
#endif /* POPAUTH */
extern bool dkimf_load_list __P((FILE *, char **, struct Peer **));
#ifdef _FFR_REPLACE_RULES
extern void dkimf_free_replist __P((struct replace *));
extern bool dkimf_load_replist __P((FILE *, struct replace **));
#endif /* _FFR_REPLACE_RULES */
extern void dkimf_lowercase __P((u_char *));
extern void dkimf_mkpath __P((char *, size_t, char *, char *));
extern bool dkimf_mkregexp __P((char *, char *, size_t));
extern void dkimf_optlist __P((FILE *));
extern void dkimf_setmaxfd __P((void));
extern int dkimf_socket_cleanup __P((char *));
extern void dkimf_stripbrackets __P((char *));
extern void dkimf_stripcr __P((char *));
extern void dkimf_trimspaces __P((u_char *));

extern struct dkimf_dstring *dkimf_dstring_new __P((int, int));
extern void dkimf_dstring_free __P((struct dkimf_dstring *));
extern bool dkimf_dstring_copy __P((struct dkimf_dstring *, char *));
extern bool dkimf_dstring_cat __P((struct dkimf_dstring *, char *));
extern bool dkimf_dstring_cat1 __P((struct dkimf_dstring *, int));
extern void dkimf_dstring_chop __P((struct dkimf_dstring *, int));
extern char *dkimf_dstring_get __P((struct dkimf_dstring *));
extern int dkimf_dstring_len __P((struct dkimf_dstring *));
extern void dkimf_dstring_blank __P((struct dkimf_dstring *));

#endif /* _UTIL_H_ */
