#ifndef _METER_H_INCLUDED
#define _METER_H_INCLUDED

#include <qwidget.h>

class QPixmap;
class QTimer;

class Meter : public QWidget
{
Q_OBJECT
public:
	Meter(QWidget *parent, const char *name=0, WFlags f=0);
	~Meter();

	void setValue(double, double);
protected:
	QTimer *peak_timer;
	QTimer *rms_timer;
	QPixmap *meter_dim, *meter_bright;
	void paintEvent(QPaintEvent *e);
	void Draw3dRect( QPainter *p, const QRect &rcRect, bool bSunken, QColor crTop, QColor crBottom );
	double curval;
	double curpeak;
	double peak;
	double rms;
protected slots:
	void clearPeak();
	void clearRms();
};
#endif
