#
# Logging.py - DITrack logging (not client-specific)
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: Logging.py 1696 2007-07-10 22:45:31Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/Logging.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import os.path
import sys
import traceback
import logging

def get_caller():
    """
    Returns the grand-caller of the function in a form of string "[FILE:LINE]".
    """

    tb = traceback.extract_stack(limit=3)[0]

    s = os.path.split(tb[0])

    fname = os.path.join(os.path.split(s[0])[1], s[1])

    return "[%s:%d]" % (fname, tb[1])

def DEBUG(str):
    """
    Sends STR to logging.debug(), prepending it with the file name and line of
    the caller.
    """

    logging.debug("%s %s" % (get_caller(), str))
