#
# update.py - DITrack 'update' command
#
# Copyright (c) 2007 The DITrack Project, www.ditrack.org.
#
# $Id: update.py 1945 2007-08-24 23:39:43Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/Command/update.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import string
import sys

# DITrack modules
import DITrack.Command.generic

class Handler(DITrack.Command.generic.Handler):
    canonical_name = "update"
    description = """Update firm entities.
usage: %s""" % canonical_name

    def run(self, opts, globals):

        if len(opts.fixed) > 1:
            raise DITrack.Command.generic.SyntaxError

        self.check_options(opts)

        maxage = None
        if "maxage" in opts.var:
            try:
                maxage = int(opts.var["maxage"])
            except ValueError:
                DITrack.Util.common.err(
                    "Non-integer max age value: '%s'" % opts.var["maxage"],
                    fatal=True
                )

        db = DITrack.Util.common.open_db(globals, opts, "w")
        client = DITrack.Client.Client(db)

        try:
            status = client.update(maxage)
        except DITrack.Client.Error, e:
            DITrack.Util.common.err(e.message, fatal=True)

        # Report the status.
        if status:
            sys.stdout.write(str(status))
