#
# dt - DITrack commands base class
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: generic.py 2257 2007-10-22 22:49:59Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/Command/generic.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import sys

class SyntaxError(Exception):
    "Syntax error detected by a handler"

class Handler:
    canonical_name = "generic command"
    description = "generic description"

    def __init__(self, *options):
        self.options = options

    def check_options(self, passed):
        "Check that options passed are all valid for this command"
        for o in passed.var.keys():
            if len(filter(lambda x: x.name == o, self.options)) == 0:
                # If no alias is set, then the value is a
                # default one.
                if passed.var_alias.has_key(o):
                    sys.stdout.write(
                        "Command '%s' doesn't accept option '%s'\n" %
                        (self.canonical_name, passed.var_alias[o])
                    )
                    sys.exit(1)

    def print_help(self, globals):
        name = self.canonical_name
        cmds = globals.command_table.map

        if len(cmds[name]) > 1:
            name = name +  " (" + ", ".join(cmds[name][1:]) + ")"

        sys.stdout.write("%s: %s\n" % (name, self.description))

        options = self.options

        if len(options):
            sys.stdout.write("\nValid options:\n")
            for o in options:
                o.print_description()

        if "description_ps" in self.__class__.__dict__:
            sys.stdout.write(self.__class__.description_ps)

    def run(self, opts, globals):
        raise NotImplementedError
