#!/usr/bin/perl

use lib '/usr/share/digitaldj';
use DDJDB;
use CGI;
use strict;

my ($playlist_id,$noartist)=@ARGV;

my $ddjdb=DDJDB->new(dbname=>"ddj_new",
                     dbserver=>"mp3box",
                     dbuser=>"ddj",
                     dbpswd=>"ddj");

die "unable to connect to db" if(!$ddjdb);


my $pl_result=$ddjdb->DBCmd("SELECT item_id FROM playlist_items WHERE ".
			    "playlist_id=$playlist_id order by position");

my $pos=1;

while (my ($id)=$pl_result->fetchrow()) {
  my $song_result=$ddjdb->DBCmd("SELECT title,play_time,artistid FROM song ".
				"WHERE id=$id");

  my ($title,$play_time,$artist_id)=$song_result->fetchrow();

  if(!$noartist) {
    my $artist_result=$ddjdb->DBCmd("SELECT artist FROM artist WHERE ".
				    "id=$artist_id");
    
    my ($artist)=$artist_result->fetchrow();
    
    printf("%02d %s -- %s (%s)\n",$pos++,$title,$artist,$play_time);
  }
  else {
    printf("%02d %s (%s)\n",$pos++,$title,$play_time);
  }
}


$ddjdb->Disconnect();
