%option noyywrap
%option yylineno

%{
#ifdef WIN32
#define strncasecmp _strnicmp
#endif

#include "SrvParser.h"
#include "Portable.h"
#define YYABORT yyterminate();
%}

%x COMMENT
%x ADDR

hexdigit [0-9A-Fa-f]
hexnumber {hexdigit}+h
letter [a-zA-Z]
cipher [0-9]
integer {cipher}+
curly_op [{]
curly_cl [}]
hex1to4  {hexdigit}{1,4}
CR \r
LF \n
EOL (({CR}{LF}?)|{LF})

%{
using namespace std;
  unsigned ComBeg;    // line, in which comment begins
  unsigned LftCnt;    // how many chars : on the left side of '::' char was interpreted
  unsigned RgtCnt;    // the same as above, but on the right side of '::'
  char Address[16];   // address, which is analizing right now
  char AddrPart[16];
  unsigned intpos,pos;

namespace std{
  yy_SrvParser_stype yylval;
}
%}

%%

{EOL}*   ; // ignore end of line
[ \t]    ; // ignore TABs and spaces

iface               { return SrvParser::IFACE_;}
class               { return SrvParser::CLASS_;}
ta-class            { return SrvParser::TACLASS_; }
stateless           { return SrvParser::STATELESS_; }
relay               { return SrvParser::RELAY_; }
interface-id        { return SrvParser::IFACE_ID_; }
interface-id-order  { return SrvParser::IFACE_ID_ORDER_; }

log-name            { return SrvParser::LOGNAME_;}
log-level           { return SrvParser::LOGLEVEL_;}
log-mode            { return SrvParser::LOGMODE_; }

work-dir            { return SrvParser::WORKDIR_;}

accept-only         { return SrvParser::ACCEPT_ONLY_;}
reject-clients      { return SrvParser::REJECT_CLIENTS_;}

T1                  { return SrvParser::T1_;}
T2                  { return SrvParser::T2_;}
prefered-lifetime   { return SrvParser::PREF_TIME_;}
valid-lifetime      { return SrvParser::VALID_TIME_;}

unicast             { return SrvParser::UNICAST_;}
preference          { return SrvParser::PREFERENCE_;}
pool                { return SrvParser::POOL_;}
share               { return SrvParser::SHARE_;}
rapid-commit        { return SrvParser::RAPID_COMMIT_;}
iface-max-lease     { return SrvParser::IFACE_MAX_LEASE_; }
class-max-lease     { return SrvParser::CLASS_MAX_LEASE_; }
client-max-lease    { return SrvParser::CLNT_MAX_LEASE_;  }
client              { return SrvParser::CLIENT_; }

option              { return SrvParser::OPTION_; }
dns-server          { return SrvParser::DNS_SERVER_;}
domain              { return SrvParser::DOMAIN_;}
ntp-server          { return SrvParser::NTP_SERVER_;}
time-zone           { return SrvParser::TIME_ZONE_;}
sip-server          { return SrvParser::SIP_SERVER_; }
sip-domain          { return SrvParser::SIP_DOMAIN_; }
fqdn                { return SrvParser::FQDN_; }
nis-server          { return SrvParser::NIS_SERVER_; }
nis-domain          { return SrvParser::NIS_DOMAIN_; }
nis\+-server        { return SrvParser::NISP_SERVER_; }
nis\+-domain        { return SrvParser::NISP_DOMAIN_; }
lifetime            { return SrvParser::LIFETIME_; }
cache-size          { return SrvParser::CACHE_SIZE_; }
pd-class	    { return SrvParser::PDCLASS_; }
pd-length	    { return SrvParser::PD_LENGTH_; }
pd-pool             { return SrvParser::PD_POOL_;}
vendor-spec         { return SrvParser::VENDOR_SPEC_; }
auth                { return SrvParser::AUTH_; }
digest-none         { return SrvParser::DIGEST_NONE_; }
digest-hmac-sha1    { return SrvParser::DIGEST_HMAC_SHA1_; }
addr-params         { return SrvParser::ADDR_PARAMS_; }
experimental        { return SrvParser::EXPERIMENTAL_; }
inactive-mode       { return SrvParser::INACTIVE_MODE_; }

yes                 { yylval.ival=1; return SrvParser::INTNUMBER_;}
no                  { yylval.ival=0; return SrvParser::INTNUMBER_;}
true                { yylval.ival=1; return SrvParser::INTNUMBER_;}
false               { yylval.ival=0; return SrvParser::INTNUMBER_;}

#.* ;

"//"(.*) ;

"/*" {
  BEGIN(COMMENT);
  ComBeg=yylineno; 
}

<COMMENT>"*/" BEGIN(INITIAL);
<COMMENT>.|"\n" ;
<COMMENT><<EOF>> {
    Log(Crit) << "Comment not closed. (/* in line " << ComBeg << LogEnd;
  { YYABORT; }
}

%{ //IPv6 address - various forms
%}
({hex1to4}:){7}{hex1to4} {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

(({hex1to4}:){1,6})?{hex1to4}"::"(({hex1to4}:){1,6})?{hex1to4} {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

"::"(({hex1to4}:){1,7})?{hex1to4} { 
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

(({hex1to4}:){0,7})?{hex1to4}:: {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

"::" {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

(({hex1to4}:){1,5})?{hex1to4}"::"(({hex1to4}:){1,6})?{integer}"."{integer}"."{integer}"."{integer} {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

"::"(({hex1to4}":"){1,6})?{integer}"."{integer}"."{integer}"."{integer} {
    if(!inet_pton6(yytext,yylval.addrval)) { 
        Log(Crit) << "Invalid address format: [" << yytext << "]" << LogEnd;
        YYABORT; 
    } else {
        return SrvParser::IPV6ADDR_;
    }
}

%{ //STRING (interface identifier,dns server etc.)
%}

('([^']|(''))*')|(\"[^\"]*\") {
    yylval.strval=new char[strlen(yytext)-1];
    strncpy(yylval.strval, yytext+1, strlen(yytext)-2);
    yylval.strval[strlen(yytext)-2]=0;
    return SrvParser::STRING_;
}

([a-zA-Z][a-zA-Z0-9\.-]+) {
    int len = strlen(yytext);
    if ( ( (len>2) && !strncasecmp("yes",yytext,3) ) ||
         ( (len>3) && !strncasecmp("true", yytext,4) )
       ) {
       yylval.ival = 1;
       return SrvParser::INTNUMBER_;
   }
    if ( ( (len>1) && !strncasecmp("no",yytext,2) ) ||
         ( (len>4) && !strncasecmp("false",yytext,5) )
       ) {
       yylval.ival = 0;
       return SrvParser::INTNUMBER_;
    }

    yylval.strval=new char[strlen(yytext)+1];
    strncpy(yylval.strval, yytext, strlen(yytext));
    yylval.strval[strlen(yytext)]=0;
    return SrvParser::STRING_;
}

0x{hexdigit}+ {
    // DUID
    int len;
    char * ptr;
    if (strlen(yytext)%2) {
        yytext[1]='0'; //if odd then no-meaning zero at the beginning
        len = strlen(yytext)-1;
        ptr = yytext+1;
    } else {
        len = strlen(yytext)-2;
        ptr = yytext+2;
    }

    //and now there is an even number of hex digits
    yylval.duidval.length = len >> 1;
    yylval.duidval.duid   = new char[len >> 1];
    for (int i=0 ; i<len; i++)
    {
        yylval.duidval.duid[i>>1]<<=4;
        if (!isxdigit(ptr[i])) { 
             Log(Crit) << "DUID parsing failed (" << yytext << ")." << LogEnd;
             YYABORT; 
        } 
        if (isalpha(ptr[i])) {
            yylval.duidval.duid[i>>1]|=toupper(ptr[i])-'A'+10;
        } else {
            yylval.duidval.duid[i>>1]|=ptr[i]-'0';
        }
   }
   return SrvParser::DUID_;
}

{hexnumber} {
    // HEX NUMBER
    yytext[strlen(yytext)-1]='\n';
    if(!sscanf(yytext,"%x",&(yylval.ival))) {
      Log(Crit) << "Hex value [" << yytext << " parsing failed." << LogEnd; 
      YYABORT; 
    }
    return SrvParser::HEXNUMBER_;
}

{integer} { 
    // DECIMAL NUMBER
    if(!sscanf(yytext,"%u",&(yylval.ival))) { 
        Log(Crit) << "Decimal value [" << yytext << " parsing failed." << LogEnd; 
        YYABORT; 
    }
    return SrvParser::INTNUMBER_;
}

.  { return yytext[0]; } 


%%

