/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/platform.hpp
 *
 * $Id: platform.hpp,v 1.8 2005/06/23 09:54:29 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Contains the class @ref diagnostics::Platform
 * which wraps all system calls (with the execption of the muetexing
 * logging_mutex.hpp).
 *
 * @test none
 */

#ifndef DIAGNOSTICS__FRAME__PLATFORM_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__PLATFORM_HPP__INCLUDE_GUARD

#include <diagnostics/frame/platform_config.hpp>

#if DIAGNOSTICS_INTERNAL_SWITCH_USE_ACE == 1

#  include <ace/OS.h> // for pid_t and ACE_thread_t

DIAGNOSTICS_NAMESPACE_BEGIN;
typedef pid_t Pid_t;
typedef ACE_thread_t Tid_t;
typedef long Sec_t;
typedef long Usec_t;

struct Platform
{
    inline static Pid_t get_pid() { return ACE_OS::getpid(); }
    inline static ACE_thread_t get_tid() { return ACE_OS::thr_self(); }
    inline static int get_time(Sec_t & sec, Usec_t & usec)
    {
		ACE_Time_Value time(ACE_OS::gettimeofday());
		sec=time.sec();
		usec=time.usec();
		return 0;
    }
    inline static int get_hostname(char * const buffer, int const buffer_len)
    {
		return ACE_OS::hostname(buffer,buffer_len);
    }
    
};

DIAGNOSTICS_NAMESPACE_END;

#endif

#endif
// vim:ts=4:sw=4
