require 'test/unit'
require 'dhelp'
require 'fileutils'

class TC_DhelpTitleDB < Test::Unit::TestCase
   TMP_DIR = 'test/tmp'

   def setup
      FileUtils.rm_r TMP_DIR if File.exists? TMP_DIR
      FileUtils.mkdir_p TMP_DIR
      @db = Dhelp::TitleDatabase.open(BDB::CREATE|BDB::TRUNCATE, {}, 0644,
                                 File.join(TMP_DIR, 'dhelptitlebase'))
   end

   def test_insert
      fooItem = Dhelp::ItemData.new(:dir     => 'foodir',
                                    :dtitle => 'Title for foodir')
      barItem = Dhelp::ItemData.new(:dir     => 'bardir',
                                    :dtitle => 'Title for bardir')
      @db.write(fooItem)
      @db.write(barItem)
      assert_equal(2, @db.size,              "Number of keys")
   end

   def teardown
      @db.close
      FileUtils.rm_rf TMP_DIR
   end
end
