require 'test/unit'
require 'dhelp'
require 'fileutils'

class TC_DocBaseDocumentPool < Test::Unit::TestCase
  def doc_base_document(path)
    Dhelp::DocBaseDocument.new("test/doc-base-pool/#{path}")
  end

  def setup
    @pool = Dhelp::DocBaseDocumentPool.new(:dirs => ['test/doc-base-pool'])
  end

  def test_each
    doc_list = []
    @pool.each do |doc|
      doc_list << doc
    end
    assert_equal Set.new(['docbook-xsl-doc-html',
                          'pica-manual',
                          'pica-manual-2']),
                 Set.new(doc_list.map {|d| d.document})
  end

  def test_section
    sections = []
    @pool.each_section do |s, docs|
      sections << s
    end
    assert_equal ['Apps/Text', 'Admin'], sections
  end

  def test_section_tree
    expected_section_tree = {
      'Apps'  => {:documents   => [],
                  :subsections => {
                     'Text' => {:documents => [doc_base_document('docbook-xsl-doc-html')], :subsections => {}}}},
      'Admin' => {:documents   => [doc_base_document('pica-manual'),
                                   doc_base_document('pica-manual-2')],
                  :subsections => {}}}
    actual_section_tree   = @pool.section_tree
    # Can't compare the whole thing because the memory addresses for the
    # DocBaseDocument objects are different :-(
    assert_equal expected_section_tree.keys, actual_section_tree.keys
    assert_equal expected_section_tree['Apps'][:subsections].keys,
                 actual_section_tree['Apps'][:subsections].keys
    assert_equal expected_section_tree['Apps'][:subsections]['Text'][:documents].map {|d| d.document},
                 actual_section_tree['Apps'][:subsections]['Text'][:documents].map {|d| d.document}
    assert_equal expected_section_tree['Admin'][:documents].map {|d| d.document},
                 actual_section_tree['Admin'][:documents].map {|d| d.document}
  end

  def teardown
    @pool = nil
  end
end
