/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _LOG_H_
#define _LOG_H_

#include <QtCore/QObject>
#include <QtCore/QDateTime>

#include <QtDBus/QDBusContext>

#include <Decibel/Types>

class LogPrivate;

/**
 * @brief The Log gives access to the connection history.
 *
 * @todo Move this into a seperate app activated by Decibel at some point.
 *
 * @author Tobias Hunger <info@basyskom.de>
 */
class Log : public QObject, protected QDBusContext
{
    Q_OBJECT

public:
    /** @brief Singleton access */
    Log(QObject * parent = 0);

    /**
     * @brief Destructor.
     */
    ~Log();

    /**
     * @brief Add an entry to the log.
     * @param entry Log entry to add.
     *
     * This method takes ownership of the log entry it is passed.
     */
    void addEntry(Decibel::LogEntry * entry);

public slots:
    /**
     * @brief Clear the log.
     */
    void clearLog();

    /**
     * @brief Get the number of entries in the log.
     */
    uint numberOfEntries() const;

    /**
     * @brief Get a log entry.
     * @param pos Position of the entry.
     * @return The string stored at the requested position in the log.
     * @throw invalid_value If there is no log entry at the given position.
     */
    Decibel::LogEntry getEntry(uint pos) const;

signals:
    /**
     * @brief Signal raised when the log is cleared.
     */
    void logCleared();
    /**
     * @brief Signal raised whenever there is a new entry added to the log.
     */
    void newEntry(const uint);

private:
    LogPrivate * const d;
};

#endif
