/*******************************************************************
 *            main.c
 *
 *  Sat Jul 29 14:14:52 2006
 *  Copyright  2006, 2007  Neil Williams
 *  linux@codehelp.co.uk
 *******************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include <glib/gstdio.h>
#include <archive.h>
#include "dvarchive.h"
#include "dvpreview.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"

/** list of other windows derived from this instance. */
static GList * subwindows = NULL;

void
dv_add_child (GtkWindow * child)
{
	subwindows = g_list_append (subwindows, child);
}

guint
dv_count_kids (void)
{
	return g_list_length (subwindows);
}

void
dv_remove_child (GtkWindow * child)
{
	subwindows = g_list_remove (subwindows, child);
}

int
main (int argc, char *argv[])
{
	DVContents * context;
	gchar **remaining_args;
	GOptionContext *option_context;
	GnomeProgram *dv;
	GtkDialog *dialog;
	GnomeVFSFileInfo *vfsinfo;
	GnomeVFSResult vfsresult;

	GOptionEntry option_entries[] = {
		/* option that collects filenames */
		{G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
			&remaining_args, NULL, _("file")},
		{NULL, 0, 0, G_OPTION_ARG_NONE, NULL, NULL, NULL}
	};

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif
	g_assert (archive_api_version () == ARCHIVE_API_VERSION);
	remaining_args = NULL;
	option_context = g_option_context_new ("");
	g_option_context_add_main_entries (option_context,
		option_entries, GETTEXT_PACKAGE);
	dv = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
		argc, argv, GNOME_PARAM_HUMAN_READABLE_NAME, _(GETTEXT_PACKAGE),
		GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
		GNOME_PARAM_GOPTION_CONTEXT, option_context, GNOME_PARAM_NONE);
	add_pixmap_directory (PACKAGE_PIXMAP_DIR);
	subwindows = NULL;
	if (!preview_init ())
		g_warning (_("Unable to create preview key file"));
	/* parse remaining command-line arguments that are not
	   options (i.e. filenames)*/
	if (remaining_args != NULL)
	{
		gint i, num_args;
		gchar * debfile;

		num_args = g_strv_length (remaining_args);
		for (i = 0; i < num_args; ++i)
		{
			/* one window for each .deb file specified */
			GtkWindow *window1;

			context = dv_create();
			window1 = GTK_WINDOW(create_deb_gview_window ());
			g_return_val_if_fail (window1, EXIT_FAILURE);
			g_object_set_data (G_OBJECT(window1), DVCONTENTS, context);
			set_dv_parent (GTK_WIDGET(window1));
			vfsinfo = gnome_vfs_file_info_new ();
			debfile = g_strdup (remaining_args[i]);
			vfsresult = gnome_vfs_get_file_info (debfile, vfsinfo, 
				GNOME_VFS_FILE_INFO_DEFAULT);
			if (vfsinfo->type == GNOME_VFS_FILE_TYPE_UNKNOWN)
			{
				/* relative locations seem to cause trouble with VFS */
				gchar * cwd = g_strconcat (g_get_current_dir(), "/", NULL);
				g_free (debfile);
				debfile = gnome_vfs_uri_make_full_from_relative (cwd, 
					remaining_args[i]);
				g_free (cwd);
				/* refresh info for the new location */
				vfsresult = gnome_vfs_get_file_info (debfile, vfsinfo, 
					GNOME_VFS_FILE_INFO_DEFAULT);
			}
			if ((vfsinfo->type == GNOME_VFS_FILE_TYPE_REGULAR) &&
				(vfsinfo->size > 0))
			{
				if (g_str_has_suffix(debfile, ".changes"))
					dv_parse_changes(debfile);
				else
				{
					set_deb_file (debfile, context);
					gtk_widget_show (GTK_WIDGET(window1));
					subwindows = g_list_append (subwindows, window1);
				}
			}
			else
			{
				dialog = GTK_DIALOG (gtk_message_dialog_new (window1,
						GTK_DIALOG_DESTROY_WITH_PARENT,	GTK_MESSAGE_ERROR,
						GTK_BUTTONS_CLOSE, _("Error loading file '%s'."),
						remaining_args[i]));
				gtk_dialog_run (dialog);
				gtk_widget_destroy (GTK_WIDGET (dialog));
				gtk_widget_show (GTK_WIDGET(window1));
				subwindows = g_list_append (subwindows, window1);
			}
			gnome_vfs_file_info_unref (vfsinfo);
		}
		g_strfreev (remaining_args);
		remaining_args = NULL;
	}
	else
	{
		GtkWindow *window1;

		context = dv_create();
		window1 = GTK_WINDOW(create_deb_gview_window ());
		g_return_val_if_fail (window1, EXIT_FAILURE);
		g_object_set_data (G_OBJECT(window1), DVCONTENTS, context);
		set_dv_parent (GTK_WIDGET(window1));
		gtk_widget_show GTK_WIDGET((window1));
		subwindows = g_list_append (subwindows, window1);
	}
	gtk_main ();
	return EXIT_SUCCESS;
}
