<?php
/*
 * $Id: class.htmlSeverities.inc.php,v 1.3.2.1.2.2 2003/11/11 05:50:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('sev');

class htmlSeverities
{
	function createCombo($default = 0, $cbName = 'severity', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly, $setid);
	}

	function GetCombo($default = 0, $cbName = 'severity', $longShort = 'name', $size = 0, $activeOnly = true, $setid = 0)
	{
		$query = "SELECT a.id,a.$longShort FROM severities a";

		if ($setid > 0)
		{
			$query .= ",attributesetsmap b WHERE a.id=b.keyid AND b.typeid=3 AND b.setid=$setid";

			if ($activeOnly)
				$query .= ' AND a.active=\'Y\'';

			$query .= ' ORDER BY b.weight';
		}
		else
		{
			if ($activeOnly)
				$query .= ' WHERE a.active=\'Y\'';

			$query .= ' ORDER BY a.name';
		}

		$oSelect = CreateObject('dcl.htmlSelect');
		$oSelect->vDefault = $default;
		$oSelect->sName = $cbName;
		$oSelect->iSize = $size;
		$oSelect->sZeroOption = STR_CMMN_SELECTONE;
		$oSelect->SetFromQuery($query);

		return $oSelect->GetHTML();
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$objDBSeverity = CreateObject('dcl.dbSeverities');
		$objDBSeverity->Connect();

		$objDBSeverity->Query("SELECT id,active,short,name,weight FROM severities ORDER BY $orderBy");
		$allRecs = $objDBSeverity->FetchAllRows();

		$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boSeverities.add') . '">' . STR_CMMN_NEW . '</a>';
		$titleLink .= '&nbsp;|&nbsp;';
		$titleLink .= '<a class="adark" href="' . menuLink('', 'menuAction=boAdmin.ShowSystemConfig') . '">' . DCL_MENU_SYSTEMSETUP . '</a>';

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_SEV_ID, 
					1 => STR_SEV_ACTIVEABB,
					2 => STR_SEV_SHORT, 
					3 => STR_SEV_NAME, 
					4 => STR_SEV_WEIGHT);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = STR_SEV_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boSeverities.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boSeverities.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_SEV_TABLETITLE, $orderBy), '', $titleLink);
		}
		else
		{
			print('<center>');
			print(STR_SEV_NOSEVS . '&nbsp;&nbsp;' . $titleLink);
			print('</center>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlSeveritiesForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', STR_SEV_EDIT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boSeverities.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_SEV_ADD);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boSeverities.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_SEV_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_SEV_SHORT);
		$Template->set_var('TXT_NAME', STR_SEV_NAME);
		$Template->set_var('TXT_WEIGHT', STR_SEV_WEIGHT);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_ATTRIBUTESNOTE', STR_CMMN_ATTRIBUTENOTE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=boSeverities.showall'));

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
			$Template->set_var('VAL_WEIGHT', $obj->weight);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('VAL_WEIGHT', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
