/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * manage_chat.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: manage_chat.c,v 1.1 2003/12/26 14:37:12 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <ctype.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <glib.h>
#include <gnome.h>

#include "global_user.h"
#include "gtk_helper.h"
#include "misc_gtk.h"
#include "gui_define.h"
#include "main.h"
#include "init_fnc.h"

#include "manage_chat.h"

/****************************************************************/
/* When user leaves the hub and a private chat session is open, */
/* display a message in chat window                             */
/****************************************************************/
void notify_private_chat(GLOB_USER *gu)
{
	GString *msg;
	GtkWidget *chat_text;
	char *pchat_label;
	int pchat_num;
	
	chat_text=get_pchat_text_widget_from_nick(gu,FALSE,&pchat_label,&pchat_num);
	
	if(chat_text!=NULL)
	{
		GtkTextView *gtv;
		GtkTextBuffer *gtb;
		GtkTextIter iter;

		gtb=gtk_text_view_get_buffer(gtv=GTK_TEXT_VIEW(chat_text));

		msg=g_string_new("");
		g_string_sprintf(msg,_("*** User %s has left the hub ***\n"), gu->fmt_nick);
		
		gtk_text_buffer_get_end_iter(gtb,&iter);
		gtk_text_buffer_insert(gtb,&iter,msg->str,-1);

		/* keep the window at the bottom place, we must use a mark, an iter does not work here */
		auto_scroll_view(gtv,gtb,chat_text);

		g_string_free(msg,TRUE);

		if(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name(main_window,"main_notebook")))!=CHAT_TAB)
			blink_on("chat_page");

		if(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name(main_window,"chat_notebook")))!=pchat_num)
			blink_on(pchat_label);
	}
}


/*******************************************************************/
/* return the GTK_TEXT widget of the chat having the LABEL == nick */
/* if nick doesn't have a private chat and create parameter is     */
/* true, the function creates one                                  */
/*******************************************************************/
GtkWidget *get_pchat_text_widget_from_nick(GLOB_USER *gu, gboolean create,char **notebook_label,int *notebook_num)
{
	GtkWidget *rhcw;
	int empty=-1;
	int i;

	for(i=0;i<9;i++)
	{
		if(!strcmp(gu->unfmt_nick,gstr_chat[i]->str))
		{
			/* we have the entry */
			(*notebook_label)=lbl_chat[i];
			(*notebook_num)=i+1;			/* +1 because the notebook page take into account the public chat page */
			return get_widget_by_widget_name(main_window,chat_text[i]);
		}
		else if((empty==-1)&&(!strcmp(gstr_chat[i]->str,"")))
		{
			empty=i;
		}
	}

	if(empty!=-1 && create)
	{
		(*notebook_label)=lbl_chat[empty];
		(*notebook_num)=empty+1;	/* +1 because the notebook page take into account the public chat page */ 
		g_string_assign(gstr_chat[empty],gu->unfmt_nick);		/* set originial nickname */
		rhcw=get_widget_by_widget_name(main_window,lbl_chat[empty]);

		gtk_label_set(GTK_LABEL(rhcw),gu->fmt_nick);
		return get_widget_by_widget_name(main_window,chat_text[empty]);
	}
	return NULL;
}

