package Gtk::Keybinding;

use strict;
use integer;
use Exporter ();
use constant TRUE  => 1;
use constant FALSE => 0;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);
use vars qw(@modifiers);
#define ShiftMask               (1<<0)
#define LockMask                (1<<1)
#define ControlMask             (1<<2)
#define Mod1Mask                (1<<3)
#define Mod2Mask                (1<<4)
#define Mod3Mask                (1<<5)
#define Mod4Mask                (1<<6)
#define Mod5Mask                (1<<7)

use constant MOD_SHIFT    => 1 << 0;
use constant MOD_LOCK     => 1 << 1;
use constant MOD_CTRL     => 1 << 2;
use constant MOD_1        => 1 << 3;
use constant MOD_2        => 1 << 4;
use constant MOD_3        => 1 << 5;
use constant MOD_4        => 1 << 6;
use constant MOD_5        => 1 << 7;

use constant MOD_CAPSLOCK => MOD_LOCK;
use constant MOD_ALT      => MOD_1;
use constant MOD_META     => MOD_1;
use constant MOD_NUMLOCK  => MOD_2;
use constant MOD_SCRLOCK  => MOD_5;
use constant MOD_ALTGR    => MOD_3;
use constant MOD_WM       => MOD_4;

@modifiers =
  qw(
     MOD_SHIFT
     MOD_LOCK
     MOD_CTRL
     MOD_1
     MOD_2
     MOD_3
     MOD_4
     MOD_5
     MOD_CAPSLOCK
     MOD_ALT
     MOD_META
     MOD_NUMLOCK
     MOD_SCRLOCK
     MOD_ALTGR
     MOD_WM
    );

@ISA         = qw(Exporter);
@EXPORT      = ();
@EXPORT_OK   = (@modifiers);
%EXPORT_TAGS = (
		modifiers => \@modifiers
	       );

$VERSION = 0.01_03;

sub make_map (@)
{
    my $callback;
  CALLBACK_CLOSURE:
    {
	my %map;

	foreach my $map_entry (@_)
	{
	    my $key  = $map_entry->{key} || ord( $map_entry->{str} );
	    my $mod  = $map_entry->{mod};
	    my $func = $map_entry->{func};

	    $map{$key} ||= {};
	    $map{$key}{$mod} = $func;
	}

	$callback =
	  sub
	  {
	      my $widget = $_[0];
	      my $event  = $_[1];

	      my $keynum = $event->{keyval};
	      my $modval = $event->{state};

	      $map{$keynum}
		&& $map{$keynum}{$modval}
		  && return $map{$keynum}{$modval}->($widget, $event);

	      return FALSE;
	  };
    };

    return $callback;
}


__END__





