/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Reflect
{
	/// <summary>representation for java.lang.Class.</summary>
	/// <remarks>
	/// representation for java.lang.Class.
	/// <br /><br />See the respective documentation in the JDK API.
	/// </remarks>
	/// <seealso cref="Db4objects.Db4o.Reflect.IReflector">Db4objects.Db4o.Reflect.IReflector
	/// 	</seealso>
	public interface IReflectClass
	{
		Db4objects.Db4o.Reflect.IReflectClass GetComponentType();

		Db4objects.Db4o.Reflect.IReflectConstructor[] GetDeclaredConstructors();

		Db4objects.Db4o.Reflect.IReflectField[] GetDeclaredFields();

		Db4objects.Db4o.Reflect.IReflectField GetDeclaredField(string name);

		Db4objects.Db4o.Reflect.IReflectClass GetDelegate();

		Db4objects.Db4o.Reflect.IReflectMethod GetMethod(string methodName, Db4objects.Db4o.Reflect.IReflectClass[]
			 paramClasses);

		string GetName();

		Db4objects.Db4o.Reflect.IReflectClass GetSuperclass();

		bool IsAbstract();

		bool IsArray();

		bool IsAssignableFrom(Db4objects.Db4o.Reflect.IReflectClass type);

		bool IsCollection();

		bool IsInstance(object obj);

		bool IsInterface();

		bool IsPrimitive();

		bool IsSecondClass();

		object NewInstance();

		Db4objects.Db4o.Reflect.IReflector Reflector();

		/// <summary>
		/// instructs to install or uninstall a special constructor for the
		/// respective platform that avoids calling the constructor for the
		/// respective class
		/// </summary>
		/// <param name="flag">
		/// true to try to install a special constructor, false if
		/// such a constructor is to be removed if present
		/// </param>
		/// <returns>true if the special constructor is in place after the call</returns>
		bool SkipConstructor(bool flag);

		void UseConstructor(Db4objects.Db4o.Reflect.IReflectConstructor constructor, object[]
			 @params);

		object[] ToArray(object obj);
	}
}
