/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Fieldindex
{
	public class IndexedPath : Db4objects.Db4o.Internal.Fieldindex.IndexedNodeBase
	{
		public static Db4objects.Db4o.Internal.Fieldindex.IIndexedNode NewParentPath(Db4objects.Db4o.Internal.Fieldindex.IIndexedNode
			 next, Db4objects.Db4o.Internal.Query.Processor.QCon constraint)
		{
			if (!CanFollowParent(constraint))
			{
				return null;
			}
			return new Db4objects.Db4o.Internal.Fieldindex.IndexedPath((Db4objects.Db4o.Internal.Query.Processor.QConObject
				)constraint.Parent(), next);
		}

		private static bool CanFollowParent(Db4objects.Db4o.Internal.Query.Processor.QCon
			 con)
		{
			Db4objects.Db4o.Internal.Query.Processor.QCon parent = con.Parent();
			Db4objects.Db4o.Internal.FieldMetadata parentField = GetYapField(parent);
			if (null == parentField)
			{
				return false;
			}
			Db4objects.Db4o.Internal.FieldMetadata conField = GetYapField(con);
			if (null == conField)
			{
				return false;
			}
			return parentField.HasIndex() && parentField.GetParentYapClass().IsAssignableFrom
				(conField.GetParentYapClass());
		}

		private static Db4objects.Db4o.Internal.FieldMetadata GetYapField(Db4objects.Db4o.Internal.Query.Processor.QCon
			 con)
		{
			Db4objects.Db4o.Internal.Query.Processor.QField field = con.GetField();
			if (null == field)
			{
				return null;
			}
			return field.GetYapField();
		}

		private Db4objects.Db4o.Internal.Fieldindex.IIndexedNode _next;

		public IndexedPath(Db4objects.Db4o.Internal.Query.Processor.QConObject parent, Db4objects.Db4o.Internal.Fieldindex.IIndexedNode
			 next) : base(parent)
		{
			_next = next;
		}

		public override System.Collections.IEnumerator GetEnumerator()
		{
			return new Db4objects.Db4o.Internal.Fieldindex.IndexedPathIterator(this, _next.GetEnumerator
				());
		}

		public override int ResultSize()
		{
			throw new System.NotSupportedException();
		}
	}
}
