/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Fieldindex
{
	public class FieldIndexProcessor
	{
		private readonly Db4objects.Db4o.Internal.Query.Processor.QCandidates _candidates;

		public FieldIndexProcessor(Db4objects.Db4o.Internal.Query.Processor.QCandidates candidates
			)
		{
			_candidates = candidates;
		}

		public virtual Db4objects.Db4o.Internal.Fieldindex.FieldIndexProcessorResult Run(
			)
		{
			Db4objects.Db4o.Internal.Fieldindex.IIndexedNode bestIndex = SelectBestIndex();
			if (null == bestIndex)
			{
				return Db4objects.Db4o.Internal.Fieldindex.FieldIndexProcessorResult.NO_INDEX_FOUND;
			}
			if (bestIndex.ResultSize() > 0)
			{
				Db4objects.Db4o.Internal.Fieldindex.IIndexedNode resolved = ResolveFully(bestIndex
					);
				if (null == resolved)
				{
					return Db4objects.Db4o.Internal.Fieldindex.FieldIndexProcessorResult.NO_INDEX_FOUND;
				}
				return new Db4objects.Db4o.Internal.Fieldindex.FieldIndexProcessorResult(resolved
					);
			}
			return Db4objects.Db4o.Internal.Fieldindex.FieldIndexProcessorResult.FOUND_INDEX_BUT_NO_MATCH;
		}

		private Db4objects.Db4o.Internal.Fieldindex.IIndexedNode ResolveFully(Db4objects.Db4o.Internal.Fieldindex.IIndexedNode
			 bestIndex)
		{
			if (null == bestIndex)
			{
				return null;
			}
			if (bestIndex.IsResolved())
			{
				return bestIndex;
			}
			return ResolveFully(bestIndex.Resolve());
		}

		public virtual Db4objects.Db4o.Internal.Fieldindex.IIndexedNode SelectBestIndex()
		{
			System.Collections.IEnumerator i = CollectIndexedNodes();
			if (!i.MoveNext())
			{
				return null;
			}
			Db4objects.Db4o.Internal.Fieldindex.IIndexedNode best = (Db4objects.Db4o.Internal.Fieldindex.IIndexedNode
				)i.Current;
			while (i.MoveNext())
			{
				Db4objects.Db4o.Internal.Fieldindex.IIndexedNode leaf = (Db4objects.Db4o.Internal.Fieldindex.IIndexedNode
					)i.Current;
				if (leaf.ResultSize() < best.ResultSize())
				{
					best = leaf;
				}
			}
			return best;
		}

		public virtual System.Collections.IEnumerator CollectIndexedNodes()
		{
			return new Db4objects.Db4o.Internal.Fieldindex.IndexedNodeCollector(_candidates).
				GetNodes();
		}
	}
}
