<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:param name="DashboardDate" select="string('')"/>

  <xsl:variable name="NormalColor">#00aa00</xsl:variable>
  <xsl:variable name="WarningColor">#ffcc66</xsl:variable>
  <xsl:variable name="ErrorColor">#ff6666</xsl:variable>

  <xsl:variable name="DarkRed">#ff6666</xsl:variable>
  <xsl:variable name="Red">#ffcc66</xsl:variable>
  <xsl:variable name="Green">#00AA00</xsl:variable>
  <xsl:variable name="Yellow">#ffff99</xsl:variable>

  <xsl:param name="CVSWebURL" />
  <xsl:param name="CVSROOT" />
  <xsl:param name="UseDoxygen" />
  <xsl:param name="BuildDoxygen" />
  <xsl:param name="DoxygenURL" />
  <xsl:param name="UseGnats" />
  <xsl:param name="GnatsWebURL" />
  <xsl:param name="ProjectURL" />
  <xsl:param name="RollupURL" />

  <xsl:variable name="LightBlue">#b0c4de</xsl:variable>

  <xsl:template name="Replace">
    <xsl:param name="str" />
    <xsl:param name="find" />
    <xsl:param name="rep" />
    <xsl:choose>
      <xsl:when test="contains($str,$find)">
        <xsl:value-of select="substring-before($str,$find)" />
        <xsl:value-of select="$rep" />
        <xsl:call-template name="Replace">
          <xsl:with-param name="str" select="substring-after($str,$find)" />
          <xsl:with-param name="find" select="$find" />
          <xsl:with-param name="rep" select="$rep" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$str" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="TranslateTestName">
    <xsl:param name="Prefix"></xsl:param>
    <xsl:param name="TestName">DummyTest</xsl:param>
    <xsl:param name="Postfix">.html</xsl:param>
    <xsl:call-template name="Replace">
      <xsl:with-param name="str" select="concat($Prefix, translate ( $TestName, '/.', '__' ) , $Postfix)"/>        
      <xsl:with-param name="find">+</xsl:with-param>
      <xsl:with-param name="rep">%2B</xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="SoftHyphenStringAtDot">
    <xsl:param name="src"/>

    <xsl:choose>
      <xsl:when test="contains($src, '.')">
        <xsl:value-of select="concat(substring-before($src, '.'), '.&#173;')"/>
        <xsl:call-template name="SoftHyphenStringAtDot">
          <xsl:with-param name="src"><xsl:value-of select="substring-after($src, '.')"/></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$src"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="SoftHyphenStringAtSlash">
    <xsl:param name="src"/>

    <xsl:choose>
      <xsl:when test="contains($src, '/')">
        <xsl:value-of select="concat(substring-before($src, '/'), '/&#173;')"/>
        <xsl:call-template name="SoftHyphenStringAtSlash">
          <xsl:with-param name="src"><xsl:value-of select="substring-after($src, '/')"/></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$src"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="SoftHyphenStringAtUnderscore">
    <xsl:param name="src"/>

    <xsl:choose>
      <xsl:when test="contains($src, '_')">
        <xsl:value-of select="concat(substring-before($src, '_'), '_&#173;')"/>
        <xsl:call-template name="SoftHyphenStringAtUnderscore">
          <xsl:with-param name="src"><xsl:value-of select="substring-after($src, '_')"/></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$src"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="DashboardFooter">
    <xsl:param name="IconDir">../../Icons</xsl:param>
    <xsl:param name="DartIcon">poweredbydart.gif</xsl:param>
    <xsl:text disable-output-escaping="yes">
	&lt;br/>
        &lt;a href="http://public.kitware.com/Dart/">&lt;img alt="Dart Home" src="</xsl:text><xsl:value-of select="$IconDir"/>/<xsl:value-of select="$DartIcon"/><xsl:text disable-output-escaping="yes">" border="0">&lt;/a>
      &lt;/body>
    &lt;/html>
    </xsl:text>
  </xsl:template>


  <xsl:template name="DashboardHeader">
    <xsl:param name="Title">Dashboard</xsl:param>
    <xsl:param name="IconDir">../../Icons</xsl:param>
    <xsl:param name="JavascriptDir">../../Javascript</xsl:param>
    <xsl:param name="DashboardDir">./</xsl:param>
    <xsl:param name="DartIcon">poweredbydart.gif</xsl:param>
    <xsl:param name="UseToolTips">0</xsl:param>
    <xsl:param name="UseCalendar">0</xsl:param>
    <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">
    &lt;html>
      &lt;head>
        &lt;meta name="robots" content="noindex,nofollow">
        &lt;meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        &lt;title> 
   </xsl:text>
    <xsl:value-of select="$Title"/> -- <xsl:value-of select="$DashboardDate"/>
    <xsl:text disable-output-escaping="yes">
        &lt;/title>
      &lt;style TYPE="text/css">
	.btip { text-decoration:none; onmouseout=hidetip(); }
	.normal { background-color : #00aa00; }
 	.warning { background-color : #ffcc66; }
	.error { background-color : #ff6666; }
	.pass { background-color : #00aa00; }
 	.fail { background-color : #ffcc66; }
	.nr { background-color : #ff6666; }
	.na { background-color : #cccccc; }
	.tr-even { background-color : #b0c4de; }
	.tr-odd { background-color : #ffffff; }
	.measurement { background-color : #b0c4de; }
	.table-heading { background-color : #b0c4de; }

        #navigator {
	   // background-color: #6699cc;
           background-color: #ffffff;
           border: 0px #0000aa solid;
           width: auto;
        }
        
        .smalldarthoverbutton {
           font-weight: bold;
           text-align: center;
           margin-bottom: 0px;
           margin-top: 0px;
        }

        .smalldarthoverbutton a {
           padding: 0px;
           text-decoration: none;
           width: 100%;
           display: block;
           color: #000000;
           background-color: #b5c9e2;
           border-top: 2px #cce3ff solid;
           border-left: 2px #cce3ff solid;
           border-bottom: 2px #31557f solid;
           border-right: 2px #31557f solid;
        }

        .smalldarthoverbutton a:hover {
           background-color: #cccc00;
           border-top: 2px #31557f solid;
           border-left: 2px #31557f solid;
           border-bottom: 2px #cccccc solid;
           border-right: 2px #cccccc solid;
        }

        .darthoverbutton {
           font-weight: bold;
           text-align: center;
           margin-bottom: 0px;
           margin-top: 0px;
	   width: 5em;
        }

        .darthoverbutton a {
           padding: 0px;
           text-decoration: none;
           width: 100%;
           display: block;
           color: #000000;
           background-color: #b5c9e2;
           border-top: 2px #cce3ff solid;
           border-left: 2px #cce3ff solid;
           border-bottom: 2px #31557f solid;
           border-right: 2px #31557f solid;
        }

        .darthoverbutton a:hover {
           background-color: #cccc00;
           border-top: 2px #31557f solid;
           border-left: 2px #31557f solid;
           border-bottom: 2px #cccccc solid;
           border-right: 2px #cccccc solid;
        }

        .hoverbutton {
           font-weight: bold;
           text-align: center;
           margin-bottom: 0px;
           margin-top: 0px;
	   width: 4em;
        }

        .hoverbutton a {
           padding: 0px;
           text-decoration: none;
           width: 100%;
           display: block;
           color: #000000;
           background-color: #bbbbbb;
           border-top: 2px #cccccc solid;
           border-left: 2px #cccccc solid;
           border-bottom: 2px #555555 solid;
           border-right: 2px #555555 solid;
        }

        .hoverbutton a:hover {
           background-color: #cccc00;
           border-top: 2px #555555 solid;
           border-left: 2px #555555 solid;
           border-bottom: 2px #cccccc solid;
           border-right: 2px #cccccc solid;
        }

	Body  {
  	  font-family : arial, helvetica, sans-serif;
  	  color : black;
        }
  
        Table  {
  	  font-family : arial, helvetica, sans-serif;
  	  color : black;
        }
  
        Table, TD  {
          font-family : arial, helvetica, sans-serif;
          color : black; 
          background-repeat : no-repeat;
        }

        Table, TH  {
          font-family : arial, helvetica, sans-serif;
          color : black; 
          background-repeat : no-repeat;
        }
  
        P {font-family : arial, helvetica, sans-serif; color: black; }

        a {
  	  Font-Family : arial, helvetica, sans-serif;
  	  Font-Style : normal;
  	  color : blue;
        }
  
        a:hover  {
  	 color : black;
         Font-Style : bold;
        }
      &lt;/style>
      &lt;/head>
      &lt;body bgcolor="#ffffff">
    </xsl:text>
    <xsl:if test="$UseCalendar != 0"><xsl:call-template name="CalendarHeader"/></xsl:if>
    <xsl:if test="$UseToolTips != 0"><xsl:call-template name="ToolTipHeader"/></xsl:if>
    <xsl:text disable-output-escaping="yes">
        &lt;table border="0" cellpadding="0" cellspacing="2" width="100%">
          &lt;tr>
            &lt;td align="center">&lt;a href="</xsl:text><xsl:value-of select="$DashboardDir"/><xsl:text disable-output-escaping="yes">/Dashboard.html">&lt;img alt="Logo/Homepage link" src="</xsl:text><xsl:value-of select="$IconDir"/><xsl:text disable-output-escaping="yes">/Logo.gif" border="0">&lt;/a>
            &lt;/td>
            &lt;td bgcolor="#6699cc" valign="top" width="100%">
   &lt;font color="#ffffff">&lt;h2></xsl:text><xsl:value-of select="$Title"/><xsl:text disable-output-escaping="yes">&lt;/h2>&lt;h3></xsl:text><xsl:value-of select="$DashboardDate"/><xsl:text disable-output-escaping="yes">&lt;/h3>&lt;/font>
        &lt;/td>&lt;/tr>&lt;tr>&lt;td>&lt;/td>&lt;td>
        &lt;div id="navigator">
        &lt;table border="0" cellpadding="0" cellspacing="0">
          &lt;tr>
	     &lt;td align="center">
                &lt;p class="darthoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$DashboardDir"/>
    <xsl:text disable-output-escaping="yes">/Dashboard.html">&amp;nbsp;Dartboard&amp;nbsp;&lt;/a>
                &lt;/p>
             &lt;/td>
    </xsl:text>
    <xsl:if test="$UseCalendar != 0">
      <xsl:text disable-output-escaping="yes">
	&lt;td align="center">
                &lt;p class="darthoverbutton">
                    &lt;a href="javascript:dartCalendar()" onClick="document.dartForm.dartDateField.value='</xsl:text><xsl:value-of select="$DashboardDate"/><xsl:text disable-output-escaping="yes">'; setDateField(document.dartForm.dartDateField); top.newWin = window.open('</xsl:text><xsl:value-of select="$JavascriptDir"/><xsl:text disable-output-escaping="yes">/calendar.html', 'cal', 'dependent=yes,resizable=yes,width=210,height=230,screenX=200,screenY=300,titlebar=yes,scrollbar=auto');">Date&lt;img BORDER=0 ALIGN=ABSMIDDLE src="</xsl:text><xsl:value-of select="$IconDir"/><xsl:text disable-output-escaping="yes">/Calendar.gif"/>&lt;/a>
                &lt;/p>
        &lt;/td>
      </xsl:text>
    </xsl:if>
    <xsl:if test="Information/Yesterday != ''">
        <xsl:text disable-output-escaping="yes">
	  &lt;td align="center">
             &lt;p class="smalldarthoverbutton">
		&lt;a href="</xsl:text><xsl:value-of select="$DashboardDir"/><xsl:text disable-output-escaping="yes">/../</xsl:text><xsl:value-of select="Information/Yesterday"/><xsl:text disable-output-escaping="yes">/Dashboard.html">&lt;img HEIGHT=16 BORDER=0 ALIGN=ABSMIDDLE alt="Previous Day" src="</xsl:text><xsl:value-of select="$IconDir"/><xsl:text disable-output-escaping="yes">/LeftBlack.gif"/>&lt;/a>
	     &lt;/p>
	  &lt;/td>
	</xsl:text>
	</xsl:if>
	<xsl:text disable-output-escaping="yes">
	  &lt;td align="center">
            &lt;p class="smalldarthoverbutton">
	       &lt;a href="</xsl:text><xsl:value-of select="$DashboardDir"/><xsl:text disable-output-escaping="yes">/../MostRecentResults-Nightly/Dashboard.html">T&lt;/a>
  	    &lt;/p>
	  &lt;/td>
	</xsl:text> 
	<xsl:if test="Information/Tomorrow != ''"> 
	  <xsl:text disable-output-escaping="yes">
	    &lt;td align="center">
             &lt;p class="smalldarthoverbutton">
		&lt;a href="</xsl:text><xsl:value-of select="$DashboardDir"/><xsl:text disable-output-escaping="yes">/../</xsl:text><xsl:value-of select="Information/Tomorrow"/><xsl:text disable-output-escaping="yes">/Dashboard.html">&lt;img HEIGHT=16 BORDER=0 ALIGN=ABSMIDDLE alt="Next Day" src="</xsl:text><xsl:value-of select="$IconDir"/><xsl:text disable-output-escaping="yes">/RightBlack.gif"/>&lt;/a>
	     &lt;/p>
	    &lt;/td>
	  </xsl:text>
        </xsl:if>
        <xsl:text disable-output-escaping="yes">
        &lt;/td>
    </xsl:text>
    <xsl:text disable-output-escaping="yes">
            &lt;td align="center">
                &lt;p class="darthoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$DashboardDir"/>
    <xsl:text disable-output-escaping="yes">/Update.html">Updates&lt;/a>
                &lt;/p>
                  &lt;/td>
                  &lt;td align="center">
                &lt;p class="darthoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$DashboardDir"/>
    <xsl:text disable-output-escaping="yes">/TestOverviewByCount.html">Tests&lt;/a>
                &lt;/p>
                  &lt;/td>
                  &lt;td align="center">
                &lt;p class="darthoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$DashboardDir"/>
    <xsl:text disable-output-escaping="yes">/BuildOverview.html">Build&lt;/a>
                &lt;/p>
                  &lt;/td>
     </xsl:text>
    <xsl:if test="$CVSWebURL!=''">
        <xsl:text disable-output-escaping="yes">
		&lt;td align="center">
                &lt;p class="hoverbutton">
                &lt;a href="</xsl:text><xsl:value-of select="$CVSWebURL"/><xsl:if test="$CVSROOT!=''">?cvsroot=<xsl:value-of select="$CVSROOT"/></xsl:if><xsl:text disable-output-escaping="yes">">CVS&lt;/a>
                &lt;/p>
                  &lt;/td>
        </xsl:text>
    </xsl:if>
     <xsl:if test="$UseDoxygen='ON'">
        <xsl:text disable-output-escaping="yes">          
		&lt;td align="center">
                &lt;p class="hoverbutton">
                    &lt;a href="</xsl:text><xsl:value-of select="$DoxygenURL"/><xsl:text disable-output-escaping="yes">">&amp;nbsp;Doxygen&amp;nbsp;&lt;/a>
                &lt;/p>
                  &lt;/td>
        </xsl:text>
    </xsl:if>
    <xsl:if test="$UseGnats='ON'">
       <xsl:text disable-output-escaping="yes">
		&lt;td align="center">
                &lt;p class="hoverbutton">
                    &lt;a href="</xsl:text><xsl:value-of select="$GnatsWebURL"/><xsl:text disable-output-escaping="yes">">Bugs&lt;/a>
                &lt;/p>
                  &lt;/td>
       </xsl:text>
    </xsl:if>
     <xsl:if test="$ProjectURL != '' ">
        <xsl:text disable-output-escaping="yes">
		&lt;td align="center">
                &lt;p class="hoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$ProjectURL"/><xsl:text disable-output-escaping="yes">">Home&lt;/a>
                &lt;/p>
                  &lt;/td>
        </xsl:text>
     </xsl:if>
     <xsl:if test="$RollupURL != '' ">
        <xsl:text disable-output-escaping="yes">
		&lt;td align="center">
                &lt;p class="hoverbutton">
                    &lt;a href="</xsl:text>
    <xsl:value-of select="$RollupURL"/><xsl:text disable-output-escaping="yes">">&amp;nbsp;Rollup&amp;nbsp;&lt;/a>
                &lt;/p>
                  &lt;/td>
        </xsl:text>
     </xsl:if>
   <xsl:text disable-output-escaping="yes">
&lt;/tr>
      &lt;/table>
    &lt;/div>
            &lt;/td>
          &lt;/tr>
        &lt;/table>
       &lt;br>
   </xsl:text>
</xsl:template>


<xsl:template name="CalendarHeader">
   <xsl:param name="IconDir">../../Icons</xsl:param>
   <xsl:param name="JavascriptDir">../../Javascript</xsl:param>

<script type="text/javascript"><xsl:attribute name="SRC"><xsl:value-of select="$JavascriptDir"/>/calendar.js</xsl:attribute>
</script>

<div id="calendar" style="visibility:hidden">
<form name="dartForm">
<input type="hidden" name="dartDateField"/>
</form>

<script type="text/javascript"><xsl:attribute name="SRC"><xsl:value-of select="$JavascriptDir"/>/DashboardMap.js</xsl:attribute>
</script>

</div>

</xsl:template>


<xsl:template name="ToolTipHeader">

<xsl:text disable-output-escaping="yes">
<![CDATA[
  <script type="text/javascript">
    /*
    Text Link/Image Map Tooltip Script- 
     Dynamic Drive (www.dynamicdrive.com)
    For full source code, installation instructions,
    100's more DHTML scripts, and Terms Of
    Use, visit dynamicdrive.com
    */
    /*
    Use is:
    <a href="URL" onMouseover="showtip(this,event,'Visit Dynamic Drive for DHTML Scripts!')" onMouseout="hidetip()">Dynamic Drive</a>
    */

    if (!document.layers&&!document.all)
    {
      event="test"
    }

    function showtip(current,e,text)
    {

      if (document.all)
      {
      thetitle=text.split('<br>')
      if (thetitle.length>1)
      {
        thetitles=''
        for (i=0;i<thetitle.length;i++)
        {
          thetitles+=thetitle[i]
        }
        current.title=thetitles
      }
      else
      {
        current.title=text
      }
    }

else if (document.layers){
document.tooltip.document.write('<layer bgColor="white" style="border:1px solid black;font-size:12px;">'+text+'</layer>')
document.tooltip.document.close()
document.tooltip.left=e.pageX+15
document.tooltip.top=e.pageY+15
document.tooltip.visibility="show"
}
}
function hidetip(){
if (document.layers)
document.tooltip.visibility="hidden"
}

</script>
<div id="tooltip" style="position:absolute;visibility:hidden"></div>
]]>
</xsl:text>
</xsl:template>



<xsl:template name="JavaScriptHeader">
   <xsl:param name="IconDir">../../Icons</xsl:param>
<script type="text/javascript">
var Icons = "<xsl:value-of select='$IconDir'/>/";
</script>
<script type="text/javascript">
<xsl:text disable-output-escaping="yes">
<![CDATA[<!--
var total=1;
var db = new Array();

// -- Enter Values Here --
// Format: dbAdd(parent[true|false] , description, URL [blank for nohref], level , TARGET [blank for "content"], image [1=yes])

// Get current cookie setting
var current=getCurrState()
function getCurrState() {
  var label = "currState="
  var labelLen = label.length
  var cLen = document.cookie.length
  var i = 0
  while (i < cLen) {
    var j = i + labelLen
    if (document.cookie.substring(i,j) == label) {
      var cEnd = document.cookie.indexOf(";",j)
      if (cEnd == -1) { cEnd = document.cookie.length }
      return unescape(document.cookie.substring(j,cEnd))
    }
    i++
  }
  return ""
}

// Record current settings in cookie
function setCurrState(setting) {
  var expire = new Date();
  expire.setTime(expire.getTime() + ( 60*60*1000 ) ); // expire in 1 hour
  document.cookie = "currState=" + escape(setting) + "; expires=" + expire.toGMTString();
  }

// Add an entry to the database
function dbAdd(mother,display,URL,indent,top,open,author,mailto,comment) {
  db[total] = new Object;
  db[total].mother = mother
  db[total].display = display
  db[total].URL = URL
  db[total].indent = indent
  db[total].top = top
  db[total].open = open
  db[total].image = ""
  db[total].author = author
  db[total].mailto = mailto
  db[total].comment = comment
  total++
  }

// toggles an outline mother entry, storing new value in the cookie
function toggle(n) {
  if (n != 0) {
    var newString = ""
    var expanded = current.substring(n-1,n) // of clicked item
    newString += current.substring(0,n-1)
    newString += expanded ^ 1 // Bitwise XOR clicked item
    newString += current.substring(n,current.length)
    setCurrState(newString) // write new state back to cookie
  }
}

// Reload page
function reload() {
  //   if (navigator.userAgent.toLowerCase().indexOf('opera') == -1) {
  //        history.go(0);
  //     } else {   
      if (document.images) {
         location.replace(location.href);
      } else {
         location.href(location.href);
      }
  //     }
}

// returns padded spaces (in mulTIPles of 2) for indenting
function pad(n) {
  var result = ""
  for (var i = 1; i <= n; i++) { result += "&nbsp;&nbsp;&nbsp;&nbsp;" }
  return result
}

// Expand everything
function explode() {
  current = "";
  initState="";
  for (var i = 1; i < db.length; i++) { 
    initState += "1"
    current += "1"
    }
  setCurrState(initState);
  reload();
  }

// Collapse everything
function contract() {
  current = "";
  initState="";
  for (var i = 1; i < db.length; i++) { 
    initState += "0"
    current += "0"
    }
  setCurrState(initState);
  reload();
  }

function tree_close() {
  window.parent.location = window.parent.content.location;
  }

//end -->]]>
</xsl:text>
</script>

</xsl:template>

<xsl:template name="JavaScriptFooter">
<script type="text/javascript">
<xsl:text disable-output-escaping="yes">
<![CDATA[<!--
	// Set the initial state if no current state or length changed
	if (current == "" || current.length != (db.length-1)) {
	current = ""
	initState = ""
	for (i = 1; i < db.length; i++) { 
	initState += db[i].open
	current += db[i].open
	}
	setCurrState(initState)
	}
	var prevIndentDisplayed = 0
	var showMyDaughter = 0
	// end -->
	 
	<!--
      	var Outline=""
	// cycle through each entry in the outline array
	for (var i = 1; i < db.length; i++) {
	  var currIndent = db[i].indent           // get the indent level
	  var expanded = current.substring(i-1,i) // current state
	 var top = db[i].top
		 if (top == "") { top="content" }
		// display entry only if it meets one of three criteria
			if ((currIndent == 0 || currIndent <= prevIndentDisplayed || (showMyDaughter == 1 && (currIndent - prevIndentDisplayed == 1)))) {
			Outline += pad(currIndent)

		// Insert the appropriate GIF and HREF
		 image = "Blank";
		 if (db[i].image==1) { image="_bullet"; }
		 if (db[i].image==2) { image="_search"; }
		 if (db[i].image==3) { image="_cal"; }
		 if (db[i].image==4) { image="_upd"; }
		 if (db[i].image==5) { image="_admin"; }
		 if (!(db[i].mother)) {
    Outline += ""
		  } 
		 else { 
		  if (current.substring(i-1,i) == 1) {
			Outline += "<A HREF=\"javascript:reload()\" onMouseOver=\"window.parent.status=\'Click to collapse\';return true;\" onClick=\"toggle(" + i + ")\">"
			Outline += "<IMG SRC=\"" + Icons + "Minus.gif\" WIDTH=16 HEIGHT=16 BORDER=0><IMG SRC=\"" + Icons + "Open.gif\" WIDTH=16 HEIGHT=16 BORDER=0>"
			Outline += "</A>"
			}
		  else {
			Outline += "<A HREF=\"javascript:reload()\" onMouseOver=\"window.parent.status=\'Click to expand\';return true;\" onClick=\"toggle(" + i + ")\">"
			Outline += "<IMG SRC=\"" + Icons + "Plus.gif\" WIDTH=16 HEIGHT=16 BORDER=0><IMG SRC=\"" + Icons + "Closed.gif\" WIDTH=16 HEIGHT=16 BORDER=0>"
			Outline += "</A>"
			}
		  }
		Outline += "&nbsp;";
     
		if (db[i].URL == "" || db[i].URL == null) {
		  Outline += " " + db[i].display      // no link, just a listed item  
		  }
		else {
		  Outline += " <A HREF=\"" + db[i].URL + "\">" + db[i].display + "</A>"
		  }
                if ( db[i].author != "" && db[i].author != null )
                {
                  if ( db[i].mailto == "" || db[i].mailto == null )
                  {
                    Outline += " by " + db[i].author
                  }
                  else
                  {
                    Outline += " by <a href=\"mailto:" + db[i].mailto + "\">" + db[i].author + "</a>"
                  }
                }
                if ( db[i].comment != null && db[i].comment != "" )
                {
                  Outline += "<br>" + pad(currIndent) + db[i].comment + "<br>"
                }
		// Bold if at level 0
		if (currIndent == 0) { 
		  Outline = "<B>" + Outline + "</B>"
		  }
//		if (currIndent == 1) {
//		    Outline += "&nbsp;<a href=details_project.html><img src=../images/document_select.gif border=0 align=bottom></a>"
//		  }
		//if (currIndent == 2) {
		//  Outline += "&nbsp;&nbsp;<a href=overview.html><img src=../images/document_overv.gif border=0></a>&nbsp;<a href=list.html><img src=../images/document_list.gif border=0></a>"
		//  }
//		if (currIndent == 3) {
//		  Outline += "&nbsp;<a href=details_part.html><img src=../images/document_select.gif border=0 align=bottom></a>"
//		  }
		//if (currIndent == 4) {
		//  Outline += "&nbsp;&nbsp;<a href=overview.html><img src=../images/document_overv.gif border=0></a>&nbsp;<a href=definition.html><img src=../images/document_definition.gif border=0></a>"
		//  }
		Outline += "<BR>"
		prevIndentDisplayed = currIndent
		showMyDaughter = expanded
		// if (i == 1) { Outline = ""}
		if (db.length > 25) {
		  document.write(Outline)
			 Outline = ""
								  }
								}
		 }
	document.write(Outline)
	// end -->]]>
</xsl:text>

</script>
<br/>
</xsl:template>

          </xsl:stylesheet>
