/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class Variable
extends Expression {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XObject execute(XPathContext xPathContext) throws TransformerException {
        if (this.m_fixUpWasCalled) {
            XObject xObject = this.m_isGlobal ? xPathContext.getVarStack().getGlobalVariable(xPathContext, this.m_index) : xPathContext.getVarStack().getLocalVariable(xPathContext, this.m_index);
            if (xObject != null) return xObject;
            this.warn(xPathContext, 11, new Object[]{this.m_qname.getLocalPart()});
            return new XNodeSet(xPathContext.getDTMManager());
        }
        Variable variable = this;
        synchronized (variable) {
            ElemVariable elemVariable;
            PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
            if (!(prefixResolver instanceof ElemTemplateElement)) throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)prefixResolver;
            while (!(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                ElemTemplateElement elemTemplateElement2 = elemTemplateElement;
                while ((elemTemplateElement = elemTemplateElement.getPreviousSiblingElem()) != null) {
                    if (!(elemTemplateElement instanceof ElemVariable) || !(elemVariable = (ElemVariable)elemTemplateElement).getName().equals(this.m_qname)) continue;
                    this.m_index = elemVariable.getIndex();
                    this.m_isGlobal = false;
                    this.m_fixUpWasCalled = true;
                    return this.execute(xPathContext);
                }
                elemTemplateElement = elemTemplateElement2.getParentElem();
            }
            elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(this.m_qname);
            if (elemVariable == null) throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
            this.m_index = elemVariable.getIndex();
            this.m_isGlobal = true;
            this.m_fixUpWasCalled = true;
            return this.execute(xPathContext);
        }
    }

    public void fixupVariables(Vector vector, int n) {
        Object object;
        this.m_fixUpWasCalled = true;
        int n2 = vector.size();
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            object = (QName)vector.elementAt(n3);
            if (((QName)object).equals(this.m_qname)) {
                if (n3 < n) {
                    this.m_isGlobal = true;
                    this.m_index = n3;
                } else {
                    this.m_index = n3 - n;
                }
                return;
            }
            --n3;
        }
        object = XSLMessages.createXPATHMessage(81, new Object[]{this.m_qname.toString()});
        TransformerException transformerException = new TransformerException((String)object, this.m_slocator);
        throw new WrappedRuntimeException(transformerException);
    }

    public boolean isStableNumber() {
        return true;
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }
}

