/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.xpath.XPathException;

public abstract class Value
implements Expression,
Serializable {
    public static Value asValue(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonNode((NodeInfo)item);
    }

    public static Item asItem(Value value, XPathContext xPathContext) throws XPathException {
        if (value instanceof EmptySequence) {
            return null;
        }
        if (value instanceof SingletonNode) {
            return ((SingletonNode)value).getNode();
        }
        if (value instanceof AtomicValue) {
            return (AtomicValue)value;
        }
        if (value instanceof Closure) {
            return value.evaluateItem(xPathContext);
        }
        SequenceIterator sequenceIterator = value.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        if (sequenceIterator.next() != null) {
            throw new AssertionError((Object)"Attempting to access a sequence as an item");
        }
        return item;
    }

    public static double stringToNumber(CharSequence charSequence) throws NumberFormatException {
        String string = Value.trimWhitespace(charSequence).toString();
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.equals("NaN")) {
            return Double.NaN;
        }
        return new Double(string);
    }

    public static CharSequence normalizeWhitespace(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        int n = 0;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    public static CharSequence collapseWhitespace(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        boolean bl = true;
        int n = 0;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    bl = false;
                }
            }
            ++n;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        int n = 0;
        int n2 = charSequence.length() - 1;
        while (charSequence.charAt(n) <= ' ') {
            if (n++ < n2) continue;
            return "";
        }
        while (charSequence.charAt(n2) <= ' ') {
            --n2;
        }
        return charSequence.subSequence(n, n2 + 1);
    }

    public final Expression simplify() {
        return this;
    }

    public final Expression analyze(StaticContext staticContext) {
        return this;
    }

    public final Expression[] getSubExpressions() {
        return ComputedExpression.NO_ARGUMENTS;
    }

    public int getSpecialProperties() {
        return 0;
    }

    public Expression promote(PromotionOffer promotionOffer) {
        return this;
    }

    public final int getDependencies() {
        return 0;
    }

    public static final int inverse(int n) {
        switch (n) {
            case 6: 
            case 22: 
            case 44: 
            case 45: {
                return n;
            }
            case 12: {
                return 11;
            }
            case 14: {
                return 13;
            }
            case 11: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 47: {
                return 46;
            }
            case 49: {
                return 48;
            }
            case 46: {
                return 47;
            }
            case 48: {
                return 49;
            }
        }
        return n;
    }

    public abstract String getStringValue() throws XPathException;

    public abstract Object convertToJava(Class var1, Configuration var2) throws XPathException;

    public abstract int conversionPreference(Class var1, Configuration var2);
}

